/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConsentFromStorage
extends AbstractConsentStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReadConsentFromStorage.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        String context = this.getStorageContext();
        String key = this.getStorageKey();
        try {
            StorageRecord storageRecord = this.getStorageService().read(context, key);
            this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, context, key});
            if (storageRecord == null) {
                this.log.debug("{} No storage record for context '{}' and key '{}'", new Object[]{this.getLogPrefix(), context, key});
                return;
            }
            Map consents = (Map)storageRecord.getValue(this.getStorageSerializer(), context, key);
            this.getConsentContext().getPreviousConsents().putAll(consents);
        }
        catch (IOException e) {
            this.log.error("{} Unable to read consent from storage", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

