/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCounter
extends AbstractConsentStorageAction {
    @Nonnull
    @NotEmpty
    public static final String COUNTER_KEY = "_counter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateCounter.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            String value = Long.toString(System.currentTimeMillis());
            String context = this.getStorageContext();
            String key = this.getStorageKey();
            StorageRecord storageRecord = this.getStorageService().read(context, key);
            this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, context, key});
            if (storageRecord == null) {
                this.log.debug("{} Creating counter with value '{}'", (Object)this.getLogPrefix(), (Object)value);
                this.getStorageService().create(context, key, value, null);
            } else {
                this.log.debug("{} Updating counter with value '{}'", (Object)this.getLogPrefix(), (Object)value);
                this.getStorageService().update(context, key, value, null);
            }
        }
        catch (IOException e) {
            this.log.debug("{} Unable to update counter", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

