/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class AttributePredicate
extends AbstractInitializableComponent
implements Predicate<IdPAttribute> {
    @Nonnull
    @NonnullElements
    private Set<String> promptedAttributeIds = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private Set<String> ignoredAttributeIds = Collections.emptySet();
    @Nullable
    private Pattern matchExpression;

    public void setPromptedAttributeIds(@Nullable @NonnullElements Collection<String> prompted) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.promptedAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(prompted));
    }

    public void setIgnoredAttributeIds(@Nullable @NonnullElements Collection<String> ignored) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoredAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(ignored));
    }

    public void setAttributeIdMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    public boolean test(@Nullable IdPAttribute input) {
        if (input == null) {
            return false;
        }
        if (this.isEmpty(input)) {
            return false;
        }
        String attributeId = input.getId();
        if (!this.promptedAttributeIds.isEmpty() && !this.promptedAttributeIds.contains(attributeId)) {
            if (this.matchExpression == null) {
                return false;
            }
            return this.matchExpression.matcher(attributeId).matches();
        }
        return !this.ignoredAttributeIds.contains(attributeId) && (this.matchExpression == null || this.matchExpression.matcher(attributeId).matches());
    }

    private boolean isEmpty(@Nonnull IdPAttribute input) {
        for (IdPAttributeValue value : input.getValues()) {
            if (value instanceof EmptyAttributeValue) continue;
            return false;
        }
        return true;
    }
}

