/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterStorageKeyComparator
implements Comparator<String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CounterStorageKeyComparator.class);
    @Nonnull
    private final List<String> storageKeys;
    @Nonnull
    private final Map<String, Long> keyToCounterMap;

    public CounterStorageKeyComparator(@Nonnull List<String> keys, @Nonnull Map<String, Long> map) {
        this.storageKeys = (List)Constraint.isNotNull(keys, (String)"Storage keys cannot be null");
        this.keyToCounterMap = (Map)Constraint.isNotNull(map, (String)"Storage key to counter map cannot be null");
    }

    @Override
    public int compare(String o1, String o2) {
        Long counter1 = this.keyToCounterMap.get(o1);
        Long counter2 = this.keyToCounterMap.get(o2);
        if (counter1 == null && counter2 == null) {
            return Integer.compare(this.storageKeys.indexOf(o1), this.storageKeys.indexOf(o2));
        }
        if (counter1 == null) {
            return -1;
        }
        if (counter2 == null) {
            return 1;
        }
        if (counter1.equals(counter2)) {
            return Integer.compare(this.storageKeys.indexOf(o1), this.storageKeys.indexOf(o2));
        }
        return Long.compare(counter1, counter2);
    }
}

