/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.RequestContext;

public class FlowIdLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FlowIdLookupFunction.class);

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        SpringRequestContext springRequestContext = (SpringRequestContext)input.getSubcontext(SpringRequestContext.class, false);
        if (springRequestContext == null) {
            return null;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        FlowExecutionContext flowExecutionContext = requestContext.getFlowExecutionContext();
        if (flowExecutionContext == null) {
            return null;
        }
        if (!flowExecutionContext.isActive()) {
            return null;
        }
        FlowDefinition flowDefinition = requestContext.getActiveFlow();
        String flowId = flowDefinition.getId();
        this.log.debug("Current flow id is '{}'", (Object)flowId);
        return flowId;
    }
}

