/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.audit.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class CurrentConsentIsApprovedAuditExtractor
implements Function<ProfileRequestContext, Collection<Boolean>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy;

    public CurrentConsentIsApprovedAuditExtractor() {
        this.consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);
    }

    public CurrentConsentIsApprovedAuditExtractor(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Collection<Boolean> apply(@Nullable ProfileRequestContext input) {
        ConsentContext consentContext = this.consentContextLookupStrategy.apply(input);
        if (consentContext != null && !consentContext.getCurrentConsents().isEmpty()) {
            return consentContext.getCurrentConsents().values().stream().map(Consent::isApproved).collect(Collectors.toList());
        }
        return CollectionSupport.emptyList();
    }
}

