/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class AbstractConsentIndexedStorageAction
extends AbstractConsentStorageAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_STORAGE_INDEX_KEY = "_key_idx";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractConsentIndexedStorageAction.class);
    @Nullable
    private String storageIndexKey;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> storageIndexKeyLookupStrategy;
    @Nullable
    private Function<Pair<ProfileRequestContext, List<String>>, List<String>> storageKeysStrategy;
    @Nonnull
    private StorageSerializer<Collection<String>> storageKeysSerializer = new CollectionSerializer();

    @Nonnull
    public StorageSerializer<Collection<String>> getStorageKeysSerializer() {
        return this.storageKeysSerializer;
    }

    public void setStorageIndexKeyLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.storageIndexKeyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage index key lookup strategy cannot be null");
    }

    public void setStorageKeysSerializer(@Nonnull StorageSerializer<Collection<String>> serializer) {
        this.checkSetterPreconditions();
        this.storageKeysSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"Storage keys serializer cannot be null");
    }

    public void setStorageKeysStrategy(@Nonnull Function<Pair<ProfileRequestContext, List<String>>, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.storageKeysStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage keys strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageIndexKeyLookupStrategy == null) {
            throw new ComponentInitializationException("Storage key lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        this.storageIndexKey = this.storageIndexKeyLookupStrategy.apply(profileRequestContext);
        this.log.trace("{} Storage index key '{}'", (Object)this.getLogPrefix(), (Object)this.storageIndexKey);
        if (this.storageIndexKey == null) {
            this.log.debug("{} No storage index key", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    @Nullable
    protected String getStorageIndexKey() {
        return this.storageIndexKey;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<String> getStorageKeysFromIndex() throws IOException {
        StorageService service = this.getStorageService();
        String context = this.getStorageContext();
        String indexKey = this.getStorageIndexKey();
        assert (service != null && indexKey != null && context != null);
        StorageRecord storageRecord = service.read(context, indexKey);
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            return CollectionSupport.emptyList();
        }
        return new ArrayList<String>((Collection)storageRecord.getValue(this.getStorageKeysSerializer(), context, indexKey));
    }

    protected boolean addKeyToStorageIndex(@Nonnull String keyToAdd) throws IOException {
        StorageService service = this.getStorageService();
        String storageContext = this.getStorageContext();
        String indexKey = this.getStorageIndexKey();
        assert (service != null && indexKey != null && storageContext != null);
        StorageRecord storageRecord = service.read(storageContext, indexKey);
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            this.log.debug("{} Creating storage index with key '{}'", (Object)this.getLogPrefix(), (Object)keyToAdd);
            return service.create(storageContext, indexKey, (Object)CollectionSupport.singletonList((Object)keyToAdd), this.storageKeysSerializer, null);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.getStorageKeysFromIndex());
        if (keys.add(keyToAdd)) {
            this.log.debug("{} Updating storage index by adding key '{}'", (Object)this.getLogPrefix(), (Object)keyToAdd);
            return service.update(storageContext, indexKey, keys, this.storageKeysSerializer, null);
        }
        this.log.debug("{} Storage key '{}' already indexed, nothing to do", (Object)this.getLogPrefix(), (Object)keyToAdd);
        return false;
    }

    protected boolean removeKeyFromStorageIndex(@Nonnull String keyToRemove) throws IOException {
        StorageService service = this.getStorageService();
        String storageContext = this.getStorageContext();
        String indexKey = this.getStorageIndexKey();
        assert (service != null && indexKey != null && storageContext != null);
        StorageRecord storageRecord = service.read(storageContext, indexKey);
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            this.log.debug("{} No storage record exists with context '{}' and key '{}', nothing to do", new Object[]{this.getLogPrefix(), this.getStorageContext(), this.getStorageIndexKey()});
            return false;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.getStorageKeysFromIndex());
        if (keys.remove(keyToRemove)) {
            this.log.debug("{} Updating storage index by removing key '{}'", (Object)this.getLogPrefix(), (Object)keyToRemove);
            assert (this.storageIndexKey != null);
            return service.update(storageContext, this.storageIndexKey, keys, this.storageKeysSerializer, null);
        }
        this.log.debug("{} Storage key '{}' not indexed, nothing to do", (Object)this.getLogPrefix(), (Object)keyToRemove);
        return false;
    }

    protected void pruneStorageRecords(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        List<String> sortedKeys;
        ConsentFlowDescriptor flowDescriptor = this.getConsentFlowDescriptor();
        StorageService service = this.getStorageService();
        String storageContext = this.getStorageContext();
        assert (service != null && flowDescriptor != null && storageContext != null);
        int maxStoredRecords = flowDescriptor.getMaximumNumberOfStoredRecords();
        if (service.getCapabilities().getValueSize() >= flowDescriptor.getExpandedStorageThreshold()) {
            maxStoredRecords = flowDescriptor.getExpandedNumberOfStoredRecords();
        }
        if (maxStoredRecords <= 0) {
            this.log.trace("{} Will not prune storage records, maximum number of records is not greater than zero", (Object)this.getLogPrefix());
            return;
        }
        List<String> keys = this.getStorageKeysFromIndex();
        if (keys.size() < maxStoredRecords) {
            this.log.debug("{} Will not prune storage records, number of keys '{}' is less than max number of records '{}'", new Object[]{this.getLogPrefix(), keys.size(), maxStoredRecords});
            return;
        }
        if (this.storageKeysStrategy != null && (sortedKeys = this.storageKeysStrategy.apply((Pair<ProfileRequestContext, List<String>>)new Pair((Object)profileRequestContext, keys))) != null) {
            keys = sortedKeys;
        }
        int numberOfKeys = keys.size();
        Iterator<String> keysIterator = keys.iterator();
        while (keysIterator.hasNext() && numberOfKeys >= maxStoredRecords) {
            String keyToDelete = keysIterator.next();
            assert (keyToDelete != null);
            this.log.debug("{} Pruning storage record with key '{}'. There are '{}' records of max '{}' ", new Object[]{this.getLogPrefix(), keyToDelete, numberOfKeys, maxStoredRecords});
            this.log.debug("{} Deleting storage record with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), this.getStorageContext(), keyToDelete});
            boolean success = service.delete(storageContext, keyToDelete);
            if (success) {
                --numberOfKeys;
            }
            this.log.debug("{} Removing key '{}' from storage index", (Object)this.getLogPrefix(), (Object)keyToDelete);
            this.removeKeyFromStorageIndex(keyToDelete);
        }
    }

    protected boolean storeResult(@Nonnull ProfileInterceptorResult result) throws IOException {
        String context = result.getStorageContext();
        String key = result.getStorageKey();
        String value = result.getStorageValue();
        Instant expiration = result.getStorageExpiration();
        int attempts = 10;
        boolean success = false;
        do {
            StorageService service = this.getStorageService();
            assert (service != null);
            success = service.create(context, key, value, expiration != null ? Long.valueOf(expiration.toEpochMilli()) : null);
            if (success) continue;
            success = service.update(context, key, value, expiration != null ? Long.valueOf(expiration.toEpochMilli()) : null);
        } while (!success && attempts-- > 0);
        if (!success) {
            this.log.error("{} Exhausted retry attempts storing result '{}'", (Object)this.getLogPrefix(), (Object)result);
        }
        return success;
    }

    protected void storeResultWithIndex(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorResult result) throws IOException {
        this.pruneStorageRecords(profileRequestContext);
        this.storeResult(result);
        this.addKeyToStorageIndex(result.getStorageKey());
    }
}

