/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class FlowDescriptorLookupFunction<T extends ProfileInterceptorFlowDescriptor>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Class<T> interceptorFlowDescriptorType;
    @Nonnull
    private Function<ProfileRequestContext, ProfileInterceptorContext> interceptorContextlookupStrategy;

    public FlowDescriptorLookupFunction(@Nonnull Class<T> type) {
        this.interceptorFlowDescriptorType = (Class)Constraint.isNotNull(type, (String)"Interceptor flow descriptor type cannot be null");
        this.interceptorContextlookupStrategy = new ChildContextLookup(ProfileInterceptorContext.class);
    }

    public void setInterceptorContextlookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileInterceptorContext> strategy) {
        this.interceptorContextlookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile interceptor context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        ProfileInterceptorContext interceptorContext = this.interceptorContextlookupStrategy.apply(input);
        if (interceptorContext == null) {
            return null;
        }
        ProfileInterceptorFlowDescriptor interceptorFlowDescriptor = interceptorContext.getAttemptedFlow();
        if (interceptorFlowDescriptor == null) {
            return null;
        }
        if (!this.interceptorFlowDescriptorType.isInstance(interceptorFlowDescriptor)) {
            return null;
        }
        return (T)((ProfileInterceptorFlowDescriptor)this.interceptorFlowDescriptorType.cast(interceptorFlowDescriptor));
    }
}

