/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import jakarta.json.JsonArray;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

public class CollectionSerializer
extends AbstractInitializableComponent
implements StorageSerializer<Collection<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CollectionSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory;
    @Nonnull
    private final JsonReaderFactory readerFactory;

    public CollectionSerializer() {
        JsonProvider provider = JsonProvider.provider();
        this.generatorFactory = provider.createGeneratorFactory(null);
        this.readerFactory = provider.createReaderFactory(null);
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Collection<String> instance) throws IOException {
        Constraint.isNotNull(instance, (String)"Storage indexes cannot be null");
        StringWriter sink = new StringWriter(128);
        try (JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);){
            gen.writeStartArray();
            for (String element : instance) {
                if (element == null) continue;
                gen.write(element);
            }
            gen.writeEnd();
        }
        String serialized = sink.toString();
        this.log.debug("Serialized '{}' as '{}'", instance, (Object)serialized);
        return serialized;
    }

    @Nonnull
    public Collection<String> deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));
        JsonStructure st = reader.read();
        if (!(st instanceof JsonArray)) {
            throw new IOException("Found invalid data structure");
        }
        ArrayList<String> collection = new ArrayList<String>();
        for (JsonValue arrayValue : (JsonArray)st) {
            if (!arrayValue.getValueType().equals((Object)JsonValue.ValueType.STRING)) continue;
            collection.add(((JsonString)arrayValue).getString());
        }
        this.log.debug("Deserialized context '{}' key '{}' value '{}' expiration '{}' as '{}'", new Object[]{context, key, value, expiration, collection});
        return collection;
    }
}

