/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptedContextLookupFunction<T extends BaseContext>
implements ContextDataLookupFunction<T, Object> {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ENGINE = "JavaScript";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedContextLookupFunction.class);
    @Nonnull
    private final EvaluableScript script;
    @Nullable
    private final String logPrefix;
    @Nullable
    private Class outputClass;
    @Nonnull
    private final Class<T> inputClass;
    @Nullable
    private Object customObject;
    private boolean hideExceptions;

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script cannot be null");
        this.logPrefix = "Scripted Function from " + extraInfo + ":";
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript) {
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script should not be null");
        this.logPrefix = "Anonymous Scripted Function:";
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo, @Nullable Class outputType) {
        this(inClass, theScript, extraInfo);
        this.outputClass = outputType;
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        this.customObject = object;
    }

    public void setHideExceptions(boolean flag) {
        this.hideExceptions = flag;
    }

    public Object apply(@Nullable T context) {
        if (null != context && !this.inputClass.isInstance(context)) {
            throw new ClassCastException(this.logPrefix + " Input was type " + context.getClass() + " which is not an instance of " + this.inputClass);
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("profileContext", context, 100);
        scriptContext.setAttribute("input", context, 100);
        scriptContext.setAttribute("custom", this.getCustomObject(), 100);
        try {
            Object output = this.script.eval((ScriptContext)scriptContext);
            if (null != this.outputClass && null != output && !this.outputClass.isInstance(output)) {
                this.log.error("{} Output of type {} was not of type {}", new Object[]{this.logPrefix, output.getClass(), this.outputClass});
                return null;
            }
            return output;
        }
        catch (ScriptException e) {
            this.log.error("{} Error while executing Function script", (Object)this.logPrefix, (Object)e);
            if (this.hideExceptions) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript(engineName, resource, null);
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedContextLookupFunction<ProfileRequestContext> scriptedContextLookupFunction = new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, resource.getDescription(), outputType);
            return scriptedContextLookupFunction;
        }
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript(DEFAULT_ENGINE, resource, null);
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript(DEFAULT_ENGINE, resource, outputType);
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline");
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline", outputType);
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline");
    }

    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline", outputType);
    }

    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript(engineName, resource, null);
    }

    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedContextLookupFunction<MessageContext> scriptedContextLookupFunction = new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, resource.getDescription(), outputType);
            return scriptedContextLookupFunction;
        }
    }

    static ScriptedContextLookupFunction resourceMessageContextScript(Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript(DEFAULT_ENGINE, resource, null);
    }

    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript(DEFAULT_ENGINE, resource, outputType);
    }

    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline");
    }

    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline", outputType);
    }

    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline");
    }

    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline", outputType);
    }
}

