/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;

public class ProfileInterceptorFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NotEmpty
    public static final String FLOW_ID_PREFIX = "intercept/";
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @Nullable
    private StorageService storageService;
    private boolean supportsNonBrowser = true;

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    public boolean isNonBrowserSupported() {
        return this.supportsNonBrowser;
    }

    public void setNonBrowserSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsNonBrowser = isSupported;
    }

    @Nullable
    public StorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(@Nonnull StorageService service) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"Storage service can not be null");
    }

    public boolean apply(ProfileRequestContext input) {
        return this.activationCondition.apply((Object)input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProfileInterceptorFlowDescriptor) {
            return this.getId().equals(((ProfileInterceptorFlowDescriptor)((Object)obj)).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("flowId", (Object)this.getId()).add("nonBrowserSupported", this.supportsNonBrowser).toString();
    }
}

