/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileInterceptorAction<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileInterceptorAction.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileInterceptorContext> interceptorContextlookupStrategy = new ChildContextLookup(ProfileInterceptorContext.class, true);
    @Nullable
    private ProfileInterceptorContext profileInterceptorContext;

    public void setLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileInterceptorContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.interceptorContextlookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.profileInterceptorContext = (ProfileInterceptorContext)((Object)this.interceptorContextlookupStrategy.apply((Object)profileRequestContext));
        if (this.profileInterceptorContext == null) {
            this.log.error("{} Unable to create or locate profile interceptor context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return this.doPreExecute(profileRequestContext, this.profileInterceptorContext) && super.doPreExecute(profileRequestContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        return true;
    }

    protected final void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        this.doExecute(profileRequestContext, this.profileInterceptorContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
    }
}

