/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributePredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributePredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    private boolean useUnfilteredAttributes = true;

    @Nonnull
    public Function<ProfileRequestContext, AttributeContext> getAttributeContextLookupStrategy() {
        return this.attributeContextLookupStrategy;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public boolean isUseUnfilteredAttributes() {
        return this.useUnfilteredAttributes;
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        Map attributes;
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)input);
        if (attributeCtx == null) {
            this.log.warn("No AttributeContext located for evaluation");
            return this.allowNullAttributeContext();
        }
        Map map = attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        if (this.hasMatch(attributes)) {
            this.log.debug("Context satisfied requirements");
            return true;
        }
        return false;
    }

    protected boolean allowNullAttributeContext() {
        return false;
    }

    protected abstract boolean hasMatch(@Nonnull @NonnullElements Map<String, IdPAttribute> var1);
}

