/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;

public class ClientTLSValidationConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<ClientTLSValidationConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<ClientTLSValidationConfiguration> apply(@Nullable ProfileRequestContext input) {
        SecurityConfiguration defaultConfig;
        SecurityConfiguration sc;
        ProfileConfiguration pc;
        ArrayList<ClientTLSValidationConfiguration> configs = new ArrayList<ClientTLSValidationConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) != null && (sc = pc.getSecurityConfiguration(input)) != null && sc.getClientTLSValidationConfiguration() != null) {
            configs.add(sc.getClientTLSValidationConfiguration());
        }
        if (input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getClientTLSValidationConfiguration() != null) {
            configs.add(defaultConfig.getClientTLSValidationConfiguration());
        }
        configs.add((ClientTLSValidationConfiguration)ConfigurationService.get(ClientTLSValidationConfiguration.class));
        return configs;
    }
}

