/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;

public class EncryptionConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<EncryptionConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        SecurityConfiguration defaultConfig;
        SecurityConfiguration sc;
        ProfileConfiguration pc;
        ArrayList<EncryptionConfiguration> configs = new ArrayList<EncryptionConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) != null && (sc = pc.getSecurityConfiguration(input)) != null && sc.getEncryptionConfiguration() != null) {
            configs.add(sc.getEncryptionConfiguration());
        }
        if (input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getEncryptionConfiguration() != null) {
            configs.add(defaultConfig.getEncryptionConfiguration());
        }
        configs.add(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
        return configs;
    }
}

