/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SpringStatusMessageLookupFunction
implements Function<ProfileRequestContext, String>,
MessageSourceAware {
    @Nonnull
    private MessageSource messageSource;

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SpringRequestContext springContext;
        if (input != null && this.messageSource != null && (springContext = (SpringRequestContext)input.getSubcontext(SpringRequestContext.class)) != null) {
            Event previousEvent;
            RequestContext springRequestContext = springContext.getRequestContext();
            Event event = previousEvent = springRequestContext != null ? springRequestContext.getCurrentEvent() : null;
            if (previousEvent != null) {
                try {
                    return this.messageSource.getMessage(previousEvent.getId(), null, springRequestContext.getExternalContext().getLocale());
                }
                catch (NoSuchMessageException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }
}

