/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.DateAttributePredicate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateAttributePredicateTest {
    private final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    private final java.time.format.DateTimeFormatter javaformatter = java.time.format.DateTimeFormatter.ISO_ZONED_DATE_TIME;

    @DataProvider(name="test-data-joda")
    public Object[][] provideTestDataJoda() {
        return new Object[][]{{new DateAttributePredicate("expirationDate"), "expirationDate", this.jodaDateStrings(Duration.standardDays((long)1L)), true}, {new DateAttributePredicate("expirationDate"), "expirationDate", this.jodaDateStrings(Duration.ZERO), false}, {new DateAttributePredicate("expirationDate"), "expirationDate", this.jodaDateStrings(Duration.standardDays((long)-1L)), false}, {this.newJodaPredicate("expirationDate", Duration.standardDays((long)90L)), "expirationDate", this.jodaDateStrings(Duration.standardDays((long)91L)), true}, {this.newJodaPredicate("expirationDate", Duration.standardDays((long)-30L)), "expirationDate", this.jodaDateStrings(Duration.standardDays((long)29L)), false}};
    }

    @DataProvider(name="test-data-java")
    public Object[][] provideTestDataJava() {
        return new Object[][]{{new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(java.time.Duration.ofDays(1L)), true}, {new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(java.time.Duration.ZERO), false}, {new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(java.time.Duration.ofDays(-1L)), false}, {this.newJavaPredicate("expirationDate", java.time.Duration.ofDays(90L)), "expirationDate", this.javaDateStrings(java.time.Duration.ofDays(91L)), true}, {this.newJavaPredicate("expirationDate", java.time.Duration.ofDays(-30L)), "expirationDate", this.javaDateStrings(java.time.Duration.ofDays(29L)), false}};
    }

    @Test(dataProvider="test-data-joda")
    public void testJodaTime(DateAttributePredicate predicate, String attribute, String[] values, boolean expected) throws Exception {
        Assert.assertEquals((boolean)predicate.test(this.createProfileRequestContext(attribute, values, null)), (boolean)expected);
    }

    @Test(dataProvider="test-data-java")
    public void testJavaTime(DateAttributePredicate predicate, String attribute, String[] values, boolean expected) throws Exception {
        Assert.assertEquals((boolean)predicate.test(this.createProfileRequestContext(attribute, values, null)), (boolean)expected);
    }

    @Test
    public void testDateTimeValues() {
        DateAttributePredicate predicate = new DateAttributePredicate("test");
        Assert.assertTrue((boolean)predicate.test(this.createProfileRequestContext("test", null, new Instant[]{Instant.now().plus(java.time.Duration.ofMinutes(5L))})));
        predicate.setOffset(java.time.Duration.ofMinutes(-10L));
        Assert.assertFalse((boolean)predicate.test(this.createProfileRequestContext("test", null, new Instant[]{Instant.now().plus(java.time.Duration.ofMinutes(5L))})));
    }

    private ProfileRequestContext createProfileRequestContext(String name, String[] values, Instant[] dtvalues) {
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpc = new RelyingPartyContext();
        IdPAttribute attribute = new IdPAttribute(name);
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        if (values != null) {
            for (String string : values) {
                attributeValues.add(new StringAttributeValue(string));
            }
        }
        if (dtvalues != null) {
            for (Instant instant : dtvalues) {
                attributeValues.add(new DateTimeAttributeValue(instant));
            }
        }
        attribute.setValues(attributeValues);
        AttributeContext ac = new AttributeContext();
        ac.setIdPAttributes(Collections.singletonList(attribute));
        ac.setUnfilteredIdPAttributes(Collections.singletonList(attribute));
        rpc.addSubcontext((BaseContext)ac);
        prc.addSubcontext((BaseContext)rpc);
        return prc;
    }

    private String[] jodaDateStrings(Duration ... offsets) {
        String[] dates = new String[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            dates[i] = this.formatter.print((ReadableInstant)DateTime.now().plus((ReadableDuration)offsets[i]));
        }
        return dates;
    }

    private String[] javaDateStrings(java.time.Duration ... offsets) {
        String[] dates = new String[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            dates[i] = this.javaformatter.format(ZonedDateTime.now().plus(offsets[i]));
        }
        return dates;
    }

    private DateAttributePredicate newJodaPredicate(String attribute, Duration offset) {
        DateAttributePredicate p = new DateAttributePredicate(attribute);
        p.setSystemTimeOffset(offset);
        return p;
    }

    private DateAttributePredicate newJavaPredicate(String attribute, java.time.Duration offset) {
        DateAttributePredicate p = new DateAttributePredicate(attribute, this.javaformatter);
        p.setOffset(offset);
        return p;
    }
}

