/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.util.Collections;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RelyingPartyIdPredicateTest {
    private ProfileRequestContext prc;
    private RelyingPartyContext rpCtx;

    @BeforeMethod
    public void setUp() {
        this.prc = new ProfileRequestContext();
        this.rpCtx = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true);
    }

    @Test
    public void testNone() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate(Collections.emptySet());
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
    }

    @Test
    public void testMatch() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate(Collections.singleton("foo"));
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertTrue((boolean)pred.test((Object)this.prc));
    }

    @Test
    public void testNoMatch() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate(Collections.singleton("bar"));
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
    }
}

