/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public abstract class AbstractProfileAction
extends AbstractConditionalProfileAction
implements Action,
MessageSource,
MessageSourceAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileAction.class);
    @Nonnull
    private Function<RequestContext, ProfileRequestContext> profileContextLookupStrategy = new WebflowRequestContextProfileRequestContextLookup();
    @Nonnull
    private MessageSource messageSource;

    @Nonnull
    public Function<RequestContext, ProfileRequestContext> getProfileContextLookupStrategy() {
        return this.profileContextLookupStrategy;
    }

    public void setProfileContextLookupStrategy(@Nonnull Function<RequestContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    @Nonnull
    public Event execute(@Nonnull RequestContext springRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext profileRequestContext = this.profileContextLookupStrategy.apply(springRequestContext);
        if (profileRequestContext == null) {
            this.log.error("{} IdP profile request context is not available", (Object)this.getLogPrefix());
            return ActionSupport.buildEvent((Object)this, "InvalidProfileContext");
        }
        return this.doExecute(springRequestContext, profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        SpringRequestContext springSubcontext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class, true);
        springSubcontext.setRequestContext(springRequestContext);
        try {
            this.execute(profileRequestContext);
        }
        finally {
            profileRequestContext.removeSubcontext((BaseContext)springSubcontext);
        }
        return this.getResult((ProfileAction)this, profileRequestContext);
    }

    @Nonnull
    protected Event getResult(@Nonnull ProfileAction action, @Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx = (EventContext)profileRequestContext.getSubcontext(EventContext.class, false);
        if (eventCtx != null) {
            Object event = eventCtx.getEvent();
            if (event instanceof Event) {
                return (Event)eventCtx.getEvent();
            }
            if (event instanceof String) {
                return ActionSupport.buildEvent(action, (String)eventCtx.getEvent());
            }
            if (event instanceof AttributeMap) {
                AttributeMap map = (AttributeMap)eventCtx.getEvent();
                return ActionSupport.buildEvent(action, map.getString("eventId", "proceed"), (AttributeMap<Object>)map);
            }
        }
        return null;
    }

    @Nullable
    protected <T> T getBean(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String name, @Nonnull Class<T> claz) {
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            return null;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            return null;
        }
        return this.getBean(requestContext, name, claz);
    }

    @Nullable
    protected <T> T getBean(@Nonnull RequestContext flowRequestContext, @Nonnull @NotEmpty String name, @Nonnull Class<T> claz) {
        try {
            Object bean = flowRequestContext.getActiveFlow().getApplicationContext().getBean(name);
            if (bean != null && claz.isInstance(bean)) {
                return claz.cast(bean);
            }
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        this.log.warn("{} No bean of the correct type found named {}", (Object)this.getLogPrefix(), (Object)name);
        return null;
    }

    @Nullable
    protected <T> T getParameter(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String name) {
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            return null;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            return null;
        }
        return this.getParameter(requestContext, name);
    }

    @Nullable
    protected <T> T getParameter(@Nonnull RequestContext flowRequestContext, @Nonnull @NotEmpty String name) {
        MutableAttributeMap scope = flowRequestContext.getFlowScope();
        if (scope != null && scope.contains(name)) {
            return (T)scope.get(name);
        }
        scope = flowRequestContext.getConversationScope();
        if (scope != null && scope.contains(name)) {
            return (T)scope.get(name);
        }
        return null;
    }

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, defaultMessage, locale);
        }
        return MessageFormat.format(defaultMessage, args);
    }

    public String getMessage(String code, Object[] args, Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, locale);
        }
        throw new NoSuchMessageException("MessageSource was not set");
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(resolvable, locale);
        }
        throw new NoSuchMessageException("MessageSource was not set");
    }

    @Nullable
    protected RequestContext getRequestContext(@Nonnull ProfileRequestContext profileRequestContext) {
        SpringRequestContext springRequestCtx = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestCtx == null) {
            return null;
        }
        return springRequestCtx.getRequestContext();
    }
}

