/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SecurityConfiguration {
    @Nonnull
    private final Duration clockSkew;
    @Nonnull
    private final IdentifierGenerationStrategy idGenerator;
    @Nullable
    private SignatureValidationConfiguration sigValidateConfig;
    @Nullable
    private SignatureSigningConfiguration sigSigningConfig;
    @Nullable
    private DecryptionConfiguration decryptConfig;
    @Nullable
    private EncryptionConfiguration encryptConfig;
    @Nullable
    private ClientTLSValidationConfiguration clientTLSConfig;
    @Nullable
    private HttpClientSecurityConfiguration httpClientConfig;

    public SecurityConfiguration() {
        this.clockSkew = Duration.ofMinutes(5L);
        this.idGenerator = new SecureRandomIdentifierGenerationStrategy();
    }

    public SecurityConfiguration(@Nonnull Duration skew, @Nonnull IdentifierGenerationStrategy generator) {
        Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
        Constraint.isFalse((skew.isNegative() || skew.isZero() ? 1 : 0) != 0, (String)"Clock skew must be greater than 0");
        this.clockSkew = skew;
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Identifier generator cannot be null");
    }

    @Nonnull
    public Duration getClockSkew() {
        return this.clockSkew;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        return this.idGenerator;
    }

    @Nullable
    public SignatureValidationConfiguration getSignatureValidationConfiguration() {
        return this.sigValidateConfig;
    }

    public void setSignatureValidationConfiguration(@Nullable SignatureValidationConfiguration config) {
        this.sigValidateConfig = config;
    }

    @Nullable
    public SignatureSigningConfiguration getSignatureSigningConfiguration() {
        return this.sigSigningConfig;
    }

    public void setSignatureSigningConfiguration(@Nullable SignatureSigningConfiguration config) {
        this.sigSigningConfig = config;
    }

    @Nullable
    public DecryptionConfiguration getDecryptionConfiguration() {
        return this.decryptConfig;
    }

    public void setDecryptionConfiguration(@Nullable DecryptionConfiguration config) {
        this.decryptConfig = config;
    }

    @Nullable
    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptConfig;
    }

    public void setEncryptionConfiguration(@Nullable EncryptionConfiguration config) {
        this.encryptConfig = config;
    }

    @Nullable
    public ClientTLSValidationConfiguration getClientTLSValidationConfiguration() {
        return this.clientTLSConfig;
    }

    public void setClientTLSValidationConfiguration(ClientTLSValidationConfiguration config) {
        this.clientTLSConfig = config;
    }

    @Nullable
    public HttpClientSecurityConfiguration getHttpClientSecurityConfiguration() {
        return this.httpClientConfig;
    }

    public void setHttpClientSecurityConfiguration(HttpClientSecurityConfiguration config) {
        this.httpClientConfig = config;
    }
}

