/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import com.google.common.base.MoreObjects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;

public class ProfileInterceptorFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
Predicate<ProfileRequestContext> {
    @Nonnull
    @NotEmpty
    public static final String FLOW_ID_PREFIX = "intercept/";
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    @Nullable
    private StorageService storageService;
    private boolean supportsNonBrowser = true;

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    public boolean isNonBrowserSupported() {
        return this.supportsNonBrowser;
    }

    public void setNonBrowserSupported(boolean isSupported) {
        this.checkSetterPreconditions();
        this.supportsNonBrowser = isSupported;
    }

    @Nullable
    public StorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(@Nonnull StorageService service) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"Storage service can not be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProfileInterceptorFlowDescriptor) {
            return this.getId().equals(((ProfileInterceptorFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).add("nonBrowserSupported", this.supportsNonBrowser).toString();
    }
}

