/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.LocalizedStringAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML1AttributeEncoder;
import net.shibboleth.idp.saml.attribute.encoding.SAMLEncoderSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1StringAttributeEncoder
extends AbstractSAML1AttributeEncoder<StringAttributeValue> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1StringAttributeEncoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof StringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nonnull IdPAttribute attribute, @Nonnull StringAttributeValue value) throws AttributeEncodingException {
        if (value instanceof LocalizedStringAttributeValue || value instanceof ScopedStringAttributeValue) {
            this.log.warn("Attribute '{}': Lossy encoding of attribute value of type {} to SAML1 String Attribute", (Object)attribute.getId(), (Object)value.getClass().getName());
        }
        return SAMLEncoderSupport.encodeStringValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (String)value.getValue(), (boolean)this.encodeType());
    }
}

