/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1NameIdentifierAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1NameIdentifierAttributeDefinition.class);
    @Nonnull
    private final SAMLObjectBuilder<NameIdentifier> nameIdentifierBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
    private String nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    private String nameIdQualifier;

    @Nullable
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    @Nullable
    public void setNameIdFormat(@Nullable String format) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIdFormat = format;
    }

    @Nullable
    public String getNameIdQualifier() {
        return this.nameIdQualifier;
    }

    public void setNameIdQualifier(@Nullable String qualifier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIdQualifier = qualifier;
    }

    protected NameIdentifier buildNameId(@Nonnull @NotEmpty String nameIdValue, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        this.log.debug("{} building a SAML1 NameIdentifier with value of '{}'", (Object)this.getLogPrefix(), (Object)nameIdValue);
        NameIdentifier nameIdentifier = (NameIdentifier)this.nameIdentifierBuilder.buildObject();
        nameIdentifier.setValue(nameIdValue);
        if (this.nameIdFormat != null) {
            this.log.debug("{} Format set to '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
            nameIdentifier.setFormat(this.nameIdFormat);
        }
        String attributeIssuerID = StringSupport.trimOrNull((String)resolutionContext.getAttributeIssuerID());
        if (this.nameIdQualifier != null) {
            nameIdentifier.setNameQualifier(this.nameIdQualifier);
            this.log.debug("{} NameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdQualifier);
        } else if (null != attributeIssuerID) {
            this.log.debug("{} NameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)attributeIssuerID);
            nameIdentifier.setNameQualifier(attributeIssuerID);
        } else {
            throw new ResolutionException(this.getLogPrefix() + " provided attribute issuer ID was empty");
        }
        return nameIdentifier;
    }

    @Nullable
    private XMLObjectAttributeValue encodeOneValue(@Nonnull IdPAttributeValue<?> theValue, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        if (theValue instanceof StringAttributeValue) {
            String value = StringSupport.trimOrNull((String)((StringAttributeValue)theValue).getValue());
            if (value == null) {
                this.log.warn("{} Value was all whitespace", (Object)this.getLogPrefix());
                return null;
            }
            NameIdentifier nid = this.buildNameId(value, resolutionContext);
            XMLObjectAttributeValue val = new XMLObjectAttributeValue((XMLObject)nid);
            return val;
        }
        this.log.warn("{} Unsupported value type: {}", (Object)this.getLogPrefix(), (Object)theValue.getClass().getName());
        return null;
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        List<XMLObjectAttributeValue> outputValues = null;
        IdPAttribute result = new IdPAttribute(this.getId());
        List inputValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies(), (String)this.getId());
        if (null != inputValues && !inputValues.isEmpty()) {
            if (1 == inputValues.size()) {
                XMLObjectAttributeValue val = this.encodeOneValue((IdPAttributeValue)inputValues.iterator().next(), resolutionContext);
                if (null != val) {
                    outputValues = Collections.singletonList(val);
                }
            } else {
                ArrayList<XMLObjectAttributeValue> xmlVals = new ArrayList<XMLObjectAttributeValue>(inputValues.size());
                for (IdPAttributeValue theValue : inputValues) {
                    XMLObjectAttributeValue val = this.encodeOneValue(theValue, resolutionContext);
                    if (null == val) continue;
                    xmlVals.add(val);
                }
                if (0 == xmlVals.size()) {
                    this.log.warn("{} No appropriate values", (Object)this.getLogPrefix());
                    return null;
                }
                outputValues = xmlVals;
            }
        }
        result.setValues(outputValues);
        return result;
    }
}

