/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataExpiredException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCryptoTransientDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseCryptoTransientDecoder.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private String logPrefix;

    @NonnullAfterInit
    public DataSealer getDataSealer() {
        return this.dataSealer;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    @Nullable
    protected String decode(@Nonnull String transientId, @Nonnull @NotEmpty String requesterId) throws NameDecoderException {
        String decodedId;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null == transientId) {
            throw new NameDecoderException(this.getLogPrefix() + " Transient identifier was null");
        }
        if (Strings.isNullOrEmpty((String)requesterId)) {
            throw new NameDecoderException(this.getLogPrefix() + " Requester ID was null");
        }
        try {
            decodedId = this.dataSealer.unwrap(transientId);
        }
        catch (DataExpiredException e) {
            throw new NameDecoderException(this.getLogPrefix() + " Principal identifier has expired");
        }
        catch (DataSealerException e) {
            this.log.debug("{} Caught exception unwrapping principal identifier", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
        if (decodedId == null) {
            throw new NameDecoderException(this.getLogPrefix() + " Unable to recover principal from transient identifier: " + transientId);
        }
        String[] parts = decodedId.split("!");
        if (parts.length != 2) {
            this.log.warn("{} Decoded principal information was invalid: {}", (Object)this.getLogPrefix(), (Object)decodedId);
            return null;
        }
        if (requesterId != null && !requesterId.equals(parts[0])) {
            this.log.warn("{} Transient identifier issued to {} but requested by {}", new Object[]{this.getLogPrefix(), parts[0], requesterId});
            return null;
        }
        return parts[1];
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSealer) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no data sealer set");
        }
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Crypto Transient Decoder '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

