/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAddAttributeStatementToAssertion
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAddAttributeStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    private boolean ignoringUnencodableAttributes = true;
    @NonnullAfterInit
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;

    public BaseAddAttributeStatementToAssertion() {
        this.idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
    }

    public boolean isStatementInOwnAssertion() {
        return this.statementInOwnAssertion;
    }

    public void setStatementInOwnAssertion(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = flag;
    }

    public boolean isIgnoringUnencodableAttributes() {
        return this.ignoringUnencodableAttributes;
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoringUnencodableAttributes = flag;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nonnull
    public AttributeContext getAttributeContext() {
        Constraint.isNotNull((Object)this.attributeCtx, (String)"AttributeContext has not been initialized yet");
        return this.attributeCtx;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        Constraint.isNotNull((Object)this.idGenerator, (String)"IdentifierGenerationStrategy has not been initialized yet");
        return this.idGenerator;
    }

    @Nonnull
    @NotEmpty
    public String getIssuerId() {
        Constraint.isNotNull((Object)this.issuerId, (String)"Issuer name has not been initialized yet");
        return this.issuerId;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add an AttributeStatement to outgoing Assertion", (Object)this.getLogPrefix());
        this.idGenerator = (IdentifierGenerationStrategy)this.idGeneratorLookupStrategy.apply((Object)profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = (String)this.issuerLookupStrategy.apply((Object)profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }
}

