/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import net.shibboleth.idp.profile.AbstractProfileAction;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateOutboundMessageContext
extends AbstractProfileAction {
    private Logger log = LoggerFactory.getLogger(PopulateOutboundMessageContext.class);

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        SAMLMessageInfoContext samlMsgInfoCtx;
        MessageContext inboundMessageContext = profileRequestContext.getInboundMessageContext();
        if (inboundMessageContext == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        MessageContext outboundMessageContext = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageContext == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        WSAddressingContext addressingInbound = (WSAddressingContext)inboundMessageContext.getSubcontext(WSAddressingContext.class);
        if (addressingInbound != null) {
            ((WSAddressingContext)outboundMessageContext.getSubcontext(WSAddressingContext.class, true)).setRelatesToURI(addressingInbound.getMessageIDURI());
            this.log.debug("Set outbound WS-Addressing RelatesTo URL: {}", (Object)((WSAddressingContext)outboundMessageContext.getSubcontext(WSAddressingContext.class)).getRelatesToURI());
        }
        if ((samlMsgInfoCtx = (SAMLMessageInfoContext)outboundMessageContext.getSubcontext(SAMLMessageInfoContext.class)) != null) {
            this.log.debug("Saw outbound SAMLMessageInfoContext with message issue instant: {}", (Object)samlMsgInfoCtx.getMessageIssueInstant());
            ((WSSecurityContext)outboundMessageContext.getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(samlMsgInfoCtx.getMessageIssueInstant());
        } else {
            ((WSSecurityContext)outboundMessageContext.getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(new DateTime());
        }
        this.log.debug("Set outbound WS-Security Timestamp Created: {}", (Object)((WSSecurityContext)outboundMessageContext.getSubcontext(WSSecurityContext.class)).getTimestampCreated());
    }
}

