/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.nameid.impl.AttributeSourcedSAML2NameIDGenerator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeSourcedSAML2NameIDGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private static final String ATTR_NAME = "foo";
    private static SAMLObjectBuilder<NameIdentifier> saml1Builder;
    private static SAMLObjectBuilder<NameID> saml2Builder;
    private static final String NAME_1 = "NameId1";
    private static final String OTHERID = "NameOtherProtocol";
    private static final String QUALIFIER = "Qualifier";
    private AttributeSourcedSAML2NameIDGenerator generator;
    private ProfileRequestContext prc;

    private static IdPAttributeValue saml1NameIdFor(String ident) {
        NameIdentifier id = (NameIdentifier)saml1Builder.buildObject();
        id.setValue(ident);
        id.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        id.setNameQualifier(QUALIFIER);
        return new XMLObjectAttributeValue((XMLObject)id);
    }

    private static IdPAttributeValue saml2NameIdFor(String ident) {
        NameID id = (NameID)saml2Builder.buildObject();
        id.setValue(ident);
        id.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        id.setNameQualifier(QUALIFIER);
        return new XMLObjectAttributeValue((XMLObject)id);
    }

    @BeforeMethod
    public void initTest() throws ComponentInitializationException {
        this.generator = new AttributeSourcedSAML2NameIDGenerator();
        this.generator.setId("test");
        this.generator.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        saml1Builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
        saml2Builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInvalidConfig() throws Exception {
        this.generator.initialize();
    }

    @Test
    public void testNoSource() throws ComponentInitializationException, SAMLException {
        this.generator.setAttributeSourceIds(Collections.singletonList("bar"));
        this.generator.initialize();
        Assert.assertNull((Object)this.generator.generate(this.prc, this.generator.getFormat()));
    }

    @Test
    public void testWrongType() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = List.of(new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        }, AttributeSourcedSAML2NameIDGeneratorTest.saml1NameIdFor(OTHERID));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        Assert.assertNull((Object)this.generator.generate(this.prc, this.generator.getFormat()));
    }

    @Test
    public void testWrongFormat() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(List.of(AttributeSourcedSAML2NameIDGeneratorTest.saml2NameIdFor(NAME_1)));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        Assert.assertNull((Object)this.generator.generate(this.prc, this.generator.getFormat()));
    }

    @Test
    public void testNameIDValued() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(List.of(AttributeSourcedSAML2NameIDGeneratorTest.saml2NameIdFor(NAME_1)));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        NameID outputNameId = (NameID)this.generator.generate(this.prc, this.generator.getFormat());
        Assert.assertNotNull((Object)outputNameId);
        Assert.assertEquals((String)outputNameId.getValue(), (String)NAME_1);
        Assert.assertEquals((String)outputNameId.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        Assert.assertEquals((String)outputNameId.getNameQualifier(), (String)QUALIFIER);
    }

    @Test
    public void testMultiNameIDValued() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(List.of(AttributeSourcedSAML2NameIDGeneratorTest.saml2NameIdFor(OTHERID), AttributeSourcedSAML2NameIDGeneratorTest.saml1NameIdFor(NAME_1)));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        NameID outputNameId = (NameID)this.generator.generate(this.prc, this.generator.getFormat());
        Assert.assertNotNull((Object)outputNameId);
        Assert.assertEquals((String)outputNameId.getValue(), (String)OTHERID);
        Assert.assertEquals((String)outputNameId.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        Assert.assertEquals((String)outputNameId.getNameQualifier(), (String)QUALIFIER);
    }

    @Test
    public void testStringValued() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(List.of(new StringAttributeValue(NAME_1)));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        NameID outputNameId = (NameID)this.generator.generate(this.prc, this.generator.getFormat());
        Assert.assertNotNull((Object)outputNameId);
        Assert.assertEquals((String)outputNameId.getValue(), (String)NAME_1);
        Assert.assertEquals((String)outputNameId.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        Assert.assertEquals((String)outputNameId.getNameQualifier(), (String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getConfiguration().getResponderId(this.prc));
    }

    @Test
    public void testScopeValued() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(List.of(new ScopedStringAttributeValue(NAME_1, QUALIFIER)));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setIdPAttributes(Collections.singleton(inputAttribute));
        this.generator.setAttributeSourceIds(Collections.singletonList(ATTR_NAME));
        this.generator.initialize();
        NameID outputNameId = (NameID)this.generator.generate(this.prc, this.generator.getFormat());
        Assert.assertNotNull((Object)outputNameId);
        Assert.assertEquals((String)outputNameId.getValue(), (String)"NameId1@Qualifier");
        Assert.assertEquals((String)outputNameId.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        Assert.assertEquals((String)outputNameId.getNameQualifier(), (String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getConfiguration().getResponderId(this.prc));
        Assert.assertEquals((String)outputNameId.getSPNameQualifier(), (String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getRelyingPartyId());
    }
}

