/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.security.Principal;
import java.time.Duration;
import java.util.Collections;
import javax.security.auth.Subject;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIdentifierDecoder;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientNameIdentifierDecoder;
import net.shibboleth.idp.saml.nameid.impl.NameIdentifierCanonicalization;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientSAML1NameIdentifierGenerator;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CryptoTransientNameIdentifierDecoderTest
extends OpenSAMLInitBaseTestCase {
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private DataSealer dataSealer;
    private CryptoTransientNameIdentifierDecoder decoder;

    @BeforeClass
    public void setupDataSealer() throws Exception {
        ClassPathResource keyStore = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.jks");
        Assert.assertTrue((boolean)keyStore.exists());
        ClassPathResource version = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.kver");
        Assert.assertTrue((boolean)version.exists());
        BasicKeystoreKeyStrategy kstrategy = new BasicKeystoreKeyStrategy();
        kstrategy.setKeyAlias("secret");
        kstrategy.setKeyPassword("kpassword");
        kstrategy.setKeystorePassword("password");
        kstrategy.setKeystoreResource(ResourceHelper.of((Resource)keyStore));
        kstrategy.setKeyVersionResource(ResourceHelper.of((Resource)version));
        kstrategy.initialize();
        this.dataSealer = new DataSealer();
        this.dataSealer.setKeyStrategy((DataSealerKeyStrategy)kstrategy);
        this.dataSealer.initialize();
        this.decoder = new CryptoTransientNameIdentifierDecoder();
        this.decoder.setDataSealer(this.dataSealer);
        this.decoder.setId("Decoder");
        this.decoder.initialize();
    }

    @Test
    public void decode() throws Exception {
        CryptoTransientIdGenerationStrategy strategy = new CryptoTransientIdGenerationStrategy();
        strategy.setDataSealer(this.dataSealer);
        strategy.setId("strategy");
        strategy.setIdLifetime(TIMEOUT);
        strategy.initialize();
        TransientSAML1NameIdentifierGenerator generator = new TransientSAML1NameIdentifierGenerator();
        generator.setId("id");
        generator.setTransientIdGenerator((TransientIdGenerationStrategy)strategy);
        generator.initialize();
        ProfileRequestContext prc = new RequestContextBuilder().setInboundMessageIssuer("https://sp.example.org/sp").buildProfileRequestContext();
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("PETER_THE_PRINCIPAL");
        NameIdentifier nameID = (NameIdentifier)generator.generate(prc, generator.getFormat());
        NameIDCanonicalizationFlowDescriptor desc = new NameIDCanonicalizationFlowDescriptor();
        desc.setId("C14NDesc");
        desc.setFormats(Collections.singleton(generator.getFormat()));
        desc.initialize();
        NameIdentifierCanonicalization canon = new NameIdentifierCanonicalization();
        canon.setDecoder((NameIdentifierDecoder)this.decoder);
        canon.initialize();
        prc = new ProfileRequestContext();
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(nameID));
        scc.setSubject(subject);
        scc.setAttemptedFlow((SubjectCanonicalizationFlowDescriptor)desc);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        canon.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertEquals((String)scc.getPrincipalName(), (String)"PETER_THE_PRINCIPAL");
    }
}

