/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.time.Duration;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientSAML1NameIdentifierGenerator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.utilities.java.support.test.resource.TestResourceConverter;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CryptoTransientSAML1NameIdentifierGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private static final Duration TIMEOUT = Duration.ofMillis(500L);
    private DataSealer sealer;
    private CryptoTransientIdGenerationStrategy transientGenerator;
    private TransientSAML1NameIdentifierGenerator generator;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException, IOException {
        ClassPathResource keyStore = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.jks");
        Assert.assertTrue((boolean)keyStore.exists());
        ClassPathResource version = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.kver");
        Assert.assertTrue((boolean)version.exists());
        BasicKeystoreKeyStrategy kstrategy = new BasicKeystoreKeyStrategy();
        kstrategy.setKeyAlias("secret");
        kstrategy.setKeyPassword("kpassword");
        kstrategy.setKeystorePassword("password");
        kstrategy.setKeystoreResource(TestResourceConverter.of((Resource)keyStore));
        kstrategy.setKeyVersionResource(TestResourceConverter.of((Resource)version));
        kstrategy.initialize();
        this.sealer = new DataSealer();
        this.sealer.setKeyStrategy((DataSealerKeyStrategy)kstrategy);
        this.sealer.initialize();
        this.transientGenerator = new CryptoTransientIdGenerationStrategy();
        this.transientGenerator.setId("test");
        this.transientGenerator.setDataSealer(this.sealer);
        this.transientGenerator.setIdLifetime(TIMEOUT);
        this.transientGenerator.initialize();
        this.generator = new TransientSAML1NameIdentifierGenerator();
        this.generator.setId("test");
        this.generator.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.generator.setTransientIdGenerator((TransientIdGenerationStrategy)this.transientGenerator);
        this.generator.initialize();
    }

    @AfterMethod
    public void tearDown() {
        this.generator.destroy();
        this.transientGenerator.destroy();
        this.sealer.destroy();
    }

    @Test
    public void testNoPrincipal() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        NameIdentifier name = (NameIdentifier)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNull((Object)name);
    }

    @Test
    public void testNoRelyingParty() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyId(null);
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("jdoe");
        NameIdentifier name = (NameIdentifier)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNull((Object)name);
    }

    @Test
    public void testTransient() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("jdoe");
        NameIdentifier name = (NameIdentifier)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((String)name.getFormat(), (String)this.generator.getFormat());
        Assert.assertEquals((String)name.getNameQualifier(), (String)rpc.getConfiguration().getResponderId(prc));
        String val = name.getValue();
        String decode = this.sealer.unwrap(val);
        Assert.assertEquals((String)decode, (String)(rpc.getRelyingPartyId() + "!jdoe"));
        Thread.sleep(TIMEOUT.multipliedBy(2L).toMillis());
        try {
            this.sealer.unwrap(val);
            Assert.fail((String)"Timeout not set correctly");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

