/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.idwsf.profile.config.SSOSProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.EvaluateDelegationPolicy;
import net.shibboleth.idp.saml.xmlobject.DelegationPolicy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluateDelegationPolicyTest
extends OpenSAMLInitBaseTestCase {
    private EvaluateDelegationPolicy action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private SSOSProfileConfiguration ssosProfileConfig;
    private List<ProfileConfiguration> profileConfigs;
    private Assertion delegatedAssertion;
    private DelegationRestrictionType delegatedRestrictionsCondition;
    private DelegationPolicy delegationPolicy;
    private String[] delegates = new String[]{"http:/foo.example.org", "http://bar.example.org", "http://baz.exqmple.org"};
    private Long policyMaxChainLength = (long)this.delegates.length + 1L;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.ssosProfileConfig = new SSOSProfileConfiguration();
        this.ssosProfileConfig.setDelegationPredicate((Predicate)Predicates.alwaysTrue());
        this.profileConfigs = new ArrayList<ProfileConfiguration>();
        this.profileConfigs.add((ProfileConfiguration)this.ssosProfileConfig);
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).setRelyingPartyProfileConfigurations(this.profileConfigs).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedRestrictionsCondition = (DelegationRestrictionType)XMLObjectSupport.getBuilder((QName)DelegationRestrictionType.TYPE_NAME).buildObject(Condition.DEFAULT_ELEMENT_NAME, DelegationRestrictionType.TYPE_NAME);
        for (String entityID : this.delegates) {
            Delegate delegate = (Delegate)XMLObjectSupport.buildXMLObject((QName)Delegate.DEFAULT_ELEMENT_NAME);
            delegate.setNameID(SAML2ActionTestingSupport.buildNameID((String)entityID));
            this.delegatedRestrictionsCondition.getDelegates().add(delegate);
        }
        this.delegatedAssertion.setConditions((Conditions)XMLObjectSupport.buildXMLObject((QName)Conditions.DEFAULT_ELEMENT_NAME));
        this.delegatedAssertion.getConditions().getConditions().add(this.delegatedRestrictionsCondition);
        this.delegationPolicy = (DelegationPolicy)XMLObjectSupport.buildXMLObject((QName)DelegationPolicy.DEFAULT_ELEMENT_NAME);
        this.delegationPolicy.setMaximumTokenDelegationChainLength(this.policyMaxChainLength);
        this.delegatedAssertion.setAdvice((Advice)XMLObjectSupport.buildXMLObject((QName)Advice.DEFAULT_ELEMENT_NAME));
        this.delegatedAssertion.getAdvice().getChildren().add(this.delegationPolicy);
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        this.action = new EvaluateDelegationPolicy();
    }

    @Test
    public void testDefaultChainLengthStrategy() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.rc);
        EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy strategy = new EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy(this.action);
        Assert.assertEquals((Object)strategy.apply(this.prc), (Object)this.policyMaxChainLength);
    }

    @Test
    public void testDefaultChainLengthStrategyNoAssertion() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        this.action.execute(this.rc);
        EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy strategy = new EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy(this.action);
        Assert.assertNull((Object)strategy.apply(this.prc));
    }

    @Test
    public void testDefaultChainLengthStrategyNoPolicy() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).getAttestedToken().setAdvice(null);
        this.action.initialize();
        this.action.execute(this.rc);
        EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy strategy = new EvaluateDelegationPolicy.PolicyMaxChainLengthStrategy(this.action);
        Assert.assertNull((Object)strategy.apply(this.prc));
    }

    @Test
    public void testSuccessNoInboundChain() throws ComponentInitializationException {
        this.delegatedAssertion.setConditions(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testSuccessChainShorterThanPolicy() throws ComponentInitializationException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testSuccessNoChainDefaultChainPolicy() throws ComponentInitializationException {
        this.delegatedAssertion.setConditions(null);
        this.action.setPolicyMaxChainLengthStrategy((Function)new MockChainLengthStrategy(null));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testChainLongerThanPolicy() throws ComponentInitializationException {
        this.action.setPolicyMaxChainLengthStrategy((Function)new MockChainLengthStrategy((long)this.delegates.length - 1L));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testChainEqualToPolicy() throws ComponentInitializationException {
        this.action.setPolicyMaxChainLengthStrategy((Function)new MockChainLengthStrategy(Long.valueOf(this.delegates.length)));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testPredicateDisallows() throws ComponentInitializationException {
        this.ssosProfileConfig.setDelegationPredicate((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testNoDelegatedAssertion() throws ComponentInitializationException {
        this.action.setAssertionTokenStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"NoCredentials");
    }

    @Test
    public void testNoRelyingPartyContext() throws ComponentInitializationException {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoProfileConfig() throws ComponentInitializationException {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    private static class MockChainLengthStrategy
    implements Function<ProfileRequestContext, Long> {
        private Long length;

        public MockChainLengthStrategy(Long value) {
            this.length = value;
        }

        @Override
        @Nullable
        public Long apply(@Nullable ProfileRequestContext input) {
            return this.length;
        }
    }
}

