/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.AddAuthnRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAuthnRequestTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext rc;
    private AuthenticationContext ac;
    private ProfileRequestContext prc1;
    private ProfileRequestContext prc2;
    private RelyingPartyContext rpc;
    private AddAuthnRequest action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().buildRequestContext();
        this.prc1 = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.ac = (AuthenticationContext)this.prc1.getSubcontext(AuthenticationContext.class, true);
        this.prc2 = (ProfileRequestContext)this.ac.getSubcontext(ProfileRequestContext.class, true);
        this.prc2.setOutboundMessageContext(new MessageContext());
        this.rpc = (RelyingPartyContext)this.prc2.getSubcontext(RelyingPartyContext.class, true);
        this.rpc.setRelyingPartyId("http://sp.example.org");
        RelyingPartyConfiguration rp = new RelyingPartyConfiguration();
        rp.setId("mock");
        rp.setResponderId("http://idp.example.org");
        rp.setDetailedErrors(true);
        rp.initialize();
        this.rpc.setConfiguration(rp);
        this.rpc.setProfileConfig((ProfileConfiguration)new BrowserSSOProfileConfiguration());
        this.action = new AddAuthnRequest();
        this.action.setProfileContextLookupStrategy(new ChildContextLookup(ProfileRequestContext.class).compose(new ChildContextLookup(AuthenticationContext.class).compose((Function)new WebflowRequestContextProfileRequestContextLookup())));
        this.action.setAuthenticationContextLookupStrategy((Function)new ParentContextLookup(AuthenticationContext.class));
        this.action.setIssuerLookupStrategy((Function)new ResponderIdLookupFunction());
        this.action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() {
        this.prc2.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testNoMessageContext() {
        this.prc2.setOutboundMessageContext(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testExistingMessage() {
        this.prc2.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSimple() {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Assert.assertEquals((String)request.getIssuer().getValue(), (String)"http://idp.example.org");
        Assert.assertFalse((boolean)request.isForceAuthn());
        Assert.assertFalse((boolean)request.isPassive());
        NameIDPolicy nid = request.getNameIDPolicy();
        Assert.assertNotNull((Object)nid);
        Assert.assertNull((Object)nid.getFormat());
        Assert.assertTrue((boolean)nid.getAllowCreate());
        Assert.assertNull((Object)request.getRequestedAuthnContext());
    }

    @Test
    public void testFlags() {
        this.ac.setIsPassive(true);
        this.ac.setForceAuthn(true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Assert.assertEquals((String)request.getIssuer().getValue(), (String)"http://idp.example.org");
        Assert.assertTrue((boolean)request.isForceAuthn());
        Assert.assertTrue((boolean)request.isPassive());
        this.prc2.getOutboundMessageContext().setMessage(null);
        ((BrowserSSOProfileConfiguration)this.rpc.getProfileConfig()).setForceAuthn(false);
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertFalse((boolean)((AuthnRequest)this.prc2.getOutboundMessageContext().getMessage()).isForceAuthn());
    }

    @Test
    public void testNameIDFormat() {
        ((BrowserSSOProfileConfiguration)this.rpc.getProfileConfig()).setNameIDFormatPrecedence(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos"));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        NameIDPolicy nid = request.getNameIDPolicy();
        Assert.assertNotNull((Object)nid);
        Assert.assertEquals((String)nid.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        Assert.assertTrue((boolean)nid.getAllowCreate());
    }

    @Test
    public void testScopingNoCount() {
        this.ac.getProxiableAuthorities().add("foo");
        this.ac.getProxiableAuthorities().add("bar");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Scoping scoping = request.getScoping();
        Assert.assertNotNull((Object)scoping);
        Assert.assertNull((Object)scoping.getProxyCount());
        Assert.assertNotNull((Object)scoping.getIDPList());
        Set requestedAuthorities = scoping.getIDPList().getIDPEntrys().stream().map(IDPEntry::getProviderID).filter(id -> id != null).collect(Collectors.toUnmodifiableSet());
        Assert.assertEquals(requestedAuthorities, (Set)this.ac.getProxiableAuthorities());
    }

    @Test
    public void testScopingCount1() {
        this.ac.setProxyCount(Integer.valueOf(1));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Scoping scoping = request.getScoping();
        Assert.assertNotNull((Object)scoping);
        Assert.assertNull((Object)scoping.getIDPList());
        Assert.assertEquals((Object)scoping.getProxyCount(), (Object)0);
    }

    @Test
    public void testScopingCount5() {
        this.ac.setProxyCount(Integer.valueOf(5));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Scoping scoping = request.getScoping();
        Assert.assertNotNull((Object)scoping);
        Assert.assertNull((Object)scoping.getIDPList());
        Assert.assertEquals((Object)scoping.getProxyCount(), (Object)4);
    }

    @Test
    public void testScopingCount0() {
        this.ac.setProxyCount(Integer.valueOf(0));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        Scoping scoping = request.getScoping();
        Assert.assertNotNull((Object)scoping);
        Assert.assertNull((Object)scoping.getIDPList());
        Assert.assertEquals((Object)scoping.getProxyCount(), (Object)0);
    }

    @Test
    public void testAuthnContext() {
        RequestedPrincipalContext reqctx = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class, true);
        reqctx.setOperator("exact");
        reqctx.setRequestedPrincipals(Arrays.asList(new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos"), new AuthenticationMethodPrincipal("urn:ietf:rfc:1510"), new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:X509")));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc2.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc2.getOutboundMessageContext().getMessage() instanceof AuthnRequest));
        AuthnRequest request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        RequestedAuthnContext rac = request.getRequestedAuthnContext();
        Assert.assertNotNull((Object)rac);
        Assert.assertEquals((Object)rac.getComparison(), (Object)AuthnContextComparisonTypeEnumeration.EXACT);
        Assert.assertEquals((int)rac.getAuthnContextClassRefs().size(), (int)2);
        Assert.assertEquals((String)((AuthnContextClassRef)rac.getAuthnContextClassRefs().get(0)).getURI(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        Assert.assertEquals((String)((AuthnContextClassRef)rac.getAuthnContextClassRefs().get(1)).getURI(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        ((BrowserSSOProfileConfiguration)this.rpc.getProfileConfig()).setAuthnContextComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        ((BrowserSSOProfileConfiguration)this.rpc.getProfileConfig()).setDefaultAuthenticationMethods(Arrays.asList(new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos"), new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:X509")));
        this.prc2.getOutboundMessageContext().setMessage(null);
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        request = (AuthnRequest)this.prc2.getOutboundMessageContext().getMessage();
        rac = request.getRequestedAuthnContext();
        Assert.assertNotNull((Object)rac);
        Assert.assertEquals((Object)rac.getComparison(), (Object)AuthnContextComparisonTypeEnumeration.EXACT);
        Assert.assertEquals((int)rac.getAuthnContextClassRefs().size(), (int)2);
        Assert.assertEquals((String)((AuthnContextClassRef)rac.getAuthnContextClassRefs().get(0)).getURI(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        Assert.assertEquals((String)((AuthnContextClassRef)rac.getAuthnContextClassRefs().get(1)).getURI(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
    }
}

