/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.AddAuthnStatementToAssertion;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.storage.StorageSerializer;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAuthnStatementToAssertionTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private AddAuthnStatementToAssertion action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.action = new AddAuthnStatementToAssertion();
        this.action.setHttpServletRequest((HttpServletRequest)new MockHttpServletRequest());
        this.action.initialize();
    }

    @Test
    public void testNoAuthnContext() {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoRelyingPartyContext() {
        this.prc.getSubcontext(AuthenticationContext.class, true);
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoContext() {
        this.prc.setOutboundMessageContext(null);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new AuthnContextClassRefPrincipal("Test")));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoAuthenticationStatement() throws Exception {
        this.prc.getSubcontext(AuthenticationContext.class, true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testAddAuthenticationStatement() throws InterruptedException, ComponentInitializationException {
        Instant now = Instant.now();
        Thread.sleep(50L);
        DefaultAuthenticationResultSerializer serializer = new DefaultAuthenticationResultSerializer();
        serializer.initialize();
        AuthenticationFlowDescriptor fd = new AuthenticationFlowDescriptor();
        fd.setId("Test");
        fd.setResultSerializer((StorageSerializer)serializer);
        fd.initialize();
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).getAvailableFlows().put("Test", fd);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new AuthnContextClassRefPrincipal("Test")));
        ((MockHttpServletRequest)this.action.getHttpServletRequest()).setRemoteAddr("127.0.0.1");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc.getOutboundMessageContext().getMessage() instanceof Response));
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull(response.getAssertions().get(0));
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertEquals((int)assertion.getAuthnStatements().size(), (int)1);
        Assert.assertNotNull(assertion.getAuthnStatements().get(0));
        AuthnStatement authenticationStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        Assert.assertTrue((boolean)authenticationStatement.getAuthnInstant().isAfter(now));
        Assert.assertNotNull((Object)authenticationStatement.getSessionIndex());
        Assert.assertNull((Object)authenticationStatement.getSessionNotOnOrAfter());
        Assert.assertNotNull((Object)authenticationStatement.getSubjectLocality());
        Assert.assertEquals((String)authenticationStatement.getSubjectLocality().getAddress(), (String)"127.0.0.1");
        AuthnContext authnContext = authenticationStatement.getAuthnContext();
        Assert.assertNotNull((Object)authnContext);
        Assert.assertNotNull((Object)authnContext.getAuthnContextClassRef());
        Assert.assertEquals((String)authnContext.getAuthnContextClassRef().getURI(), (String)"Test");
        Assert.assertTrue((boolean)authnContext.getAuthenticatingAuthorities().isEmpty());
    }

    @Test
    public void testSessionNotOnOrAfter() {
        BrowserSSOProfileConfiguration ssoConfig = new BrowserSSOProfileConfiguration();
        ssoConfig.setMaximumSPSessionLifetime(Duration.ofHours(1L));
        ssoConfig.setSecurityConfiguration(new SecurityConfiguration());
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)ssoConfig);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new AuthnContextClassRefPrincipal("Test")));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        AuthnStatement authenticationStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        Assert.assertNotNull((Object)authenticationStatement.getSessionNotOnOrAfter());
    }

    @Test
    public void testAddAuthenticationStatementAndMethod() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthnContextClassRefPrincipal("Foo"));
        subject.getPrincipals().add((Principal)new AuthnContextClassRefPrincipal("Bar"));
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", subject));
        RequestedPrincipalContext requested = new RequestedPrincipalContext();
        requested.setMatchingPrincipal((Principal)new AuthnContextClassRefPrincipal("Bar"));
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, false)).addSubcontext((BaseContext)requested);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc.getOutboundMessageContext().getMessage() instanceof Response));
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull(response.getAssertions().get(0));
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertEquals((int)assertion.getAuthnStatements().size(), (int)1);
        Assert.assertNotNull(assertion.getAuthnStatements().get(0));
        AuthnStatement authenticationStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        AuthnContext authnContext = authenticationStatement.getAuthnContext();
        Assert.assertNotNull((Object)authnContext);
        Assert.assertNotNull((Object)authnContext.getAuthnContextClassRef());
        Assert.assertEquals((String)authnContext.getAuthnContextClassRef().getURI(), (String)"Bar");
        Assert.assertTrue((boolean)authnContext.getAuthenticatingAuthorities().isEmpty());
    }

    @Test
    public void testAuthenticatingAuthorities() {
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new ProxyAuthenticationPrincipal(List.of("foo", "bar", "baz"))));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        AuthnStatement authenticationStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        AuthnContext authnContext = authenticationStatement.getAuthnContext();
        Assert.assertNotNull((Object)authnContext);
        Assert.assertEquals((int)authnContext.getAuthenticatingAuthorities().size(), (int)3);
        Assert.assertEquals((String)((AuthenticatingAuthority)authnContext.getAuthenticatingAuthorities().get(0)).getURI(), (String)"foo");
        Assert.assertEquals((String)((AuthenticatingAuthority)authnContext.getAuthenticatingAuthorities().get(1)).getURI(), (String)"bar");
        Assert.assertEquals((String)((AuthenticatingAuthority)authnContext.getAuthenticatingAuthorities().get(2)).getURI(), (String)"baz");
    }

    @Test
    public void testSuppressedAuthenticatingAuthorities() {
        BrowserSSOProfileConfiguration ssoConfig = new BrowserSSOProfileConfiguration();
        ssoConfig.setSuppressAuthenticatingAuthority(true);
        ssoConfig.setSecurityConfiguration(new SecurityConfiguration());
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)ssoConfig);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new ProxyAuthenticationPrincipal(List.of("foo", "bar", "baz"))));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        AuthnStatement authenticationStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        AuthnContext authnContext = authenticationStatement.getAuthnContext();
        Assert.assertNotNull((Object)authnContext);
        Assert.assertTrue((boolean)authnContext.getAuthenticatingAuthorities().isEmpty());
    }
}

