/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.Collections;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.PopulateEncryptionParameters;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateEncryptionParametersTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private PopulateEncryptionParameters action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singletonList(new net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration())).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.action = new PopulateEncryptionParameters();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test
    public void testNoConfig() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testWrongConfig() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)new BrowserSSOProfileConfiguration());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testResolverError() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(true));
        this.action.initialize();
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSuccess() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        EncryptionContext ctx = (EncryptionContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(EncryptionContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertNotNull((Object)ctx.getAssertionEncryptionParameters());
        Assert.assertNull((Object)ctx.getIdentifierEncryptionParameters());
        Assert.assertNull((Object)ctx.getAttributeEncryptionParameters());
    }

    @Test
    public void testOptional() throws Exception {
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockResolver(true));
        this.action.initialize();
        ((net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig()).setEncryptionOptional(true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        EncryptionContext ctx = (EncryptionContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(EncryptionContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertNull((Object)ctx.getAssertionEncryptionParameters());
        Assert.assertNull((Object)ctx.getIdentifierEncryptionParameters());
        Assert.assertNull((Object)ctx.getAttributeEncryptionParameters());
    }

    private class MockResolver
    implements EncryptionParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<EncryptionParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public EncryptionParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)), (String)"Criterion was null");
            return new EncryptionParameters();
        }
    }
}

