/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.xmlobject.impl;

import net.shibboleth.idp.saml.xmlobject.DelegationPolicy;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DelegationPolicyTest
extends XMLObjectProviderBaseTestCase {
    private Long expectedMaxChainLength;

    public DelegationPolicyTest() {
        this.singleElementFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibDelegationPolicy.xml";
        this.singleElementOptionalAttributesFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibDelegationPolicyOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedMaxChainLength = 5L;
    }

    @Test
    public void testSingleElementMarshall() {
        DelegationPolicy delegationPolicy = (DelegationPolicy)this.buildXMLObject(DelegationPolicy.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)delegationPolicy);
    }

    @Test
    public void testSingleElementUnmarshall() {
        DelegationPolicy delegationPolicy = (DelegationPolicy)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)delegationPolicy, (String)"Unmarshalled object was null");
        Assert.assertNull((Object)delegationPolicy.getMaximumTokenDelegationChainLength(), (String)"MaximumTokenDelegationChainLength attribute value");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        DelegationPolicy delegationPolicy = (DelegationPolicy)this.buildXMLObject(DelegationPolicy.DEFAULT_ELEMENT_NAME);
        delegationPolicy.setMaximumTokenDelegationChainLength(this.expectedMaxChainLength);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)delegationPolicy);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        DelegationPolicy delegationPolicy = (DelegationPolicy)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)delegationPolicy, (String)"Unmarshalled object was null");
        Assert.assertEquals((Object)delegationPolicy.getMaximumTokenDelegationChainLength(), (Object)this.expectedMaxChainLength, (String)"VerifyDepth attribute value");
    }
}

