/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.xmlobject.impl;

import net.shibboleth.idp.saml.xmlobject.Scope;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ScopeTest
extends XMLObjectProviderBaseTestCase {
    private String expectedContent;
    private Boolean expectedRegexp;

    public ScopeTest() {
        this.singleElementFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibMDScope.xml";
        this.singleElementOptionalAttributesFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibMDScopeOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedContent = "ThisIsSomeScopeValue";
        this.expectedRegexp = Boolean.TRUE;
    }

    @Test
    public void testSingleElementMarshall() {
        Scope scope = (Scope)this.buildXMLObject(Scope.DEFAULT_ELEMENT_NAME);
        scope.setValue(this.expectedContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)scope);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Scope scope = (Scope)this.buildXMLObject(Scope.DEFAULT_ELEMENT_NAME);
        scope.setValue(this.expectedContent);
        scope.setRegexp(this.expectedRegexp);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)scope);
    }

    @Test
    public void testSingleElementUnmarshall() {
        Scope scope = (Scope)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)scope, (String)"Unmarshalled object was null");
        Assert.assertEquals((String)scope.getValue(), (String)this.expectedContent, (String)"Scope value");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)scope.getRegexp(), (String)"Regexp attribute value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Scope scope = (Scope)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)scope, (String)"Unmarshalled object was null");
        Assert.assertEquals((String)scope.getValue(), (String)this.expectedContent, (String)"Scope value");
        Assert.assertEquals((Object)this.expectedRegexp, (Object)scope.getRegexp(), (String)"Regexp attribute value");
    }

    @Test
    public void testXSBooleanAttributes() {
        Scope scope = (Scope)this.buildXMLObject(Scope.DEFAULT_ELEMENT_NAME);
        scope.setRegexp(Boolean.TRUE);
        Assert.assertEquals((Object)scope.getRegexp(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)scope.getRegexpXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)scope.getRegexpXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)scope.getRegexpXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        scope.setRegexp(Boolean.FALSE);
        Assert.assertEquals((Object)scope.getRegexp(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)scope.getRegexpXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)scope.getRegexpXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)scope.getRegexpXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        scope.setRegexp((Boolean)null);
        Assert.assertEquals((Object)scope.getRegexp(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)scope.getRegexpXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

