/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.xmlobject.impl;

import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ScopedValueTest
extends XMLObjectProviderBaseTestCase {
    private String expectedValue;
    private String expectedScope;
    private String scopeAttribute;
    private String scopeDelimiter;

    public ScopedValueTest() {
        this.singleElementFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibScopedValue.xml";
        this.singleElementOptionalAttributesFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibScopedValueOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedValue = "member";
        this.expectedScope = "example.edu";
        this.scopeAttribute = "scope";
        this.scopeDelimiter = "@";
    }

    @Test
    public void testSingleElementMarshall() {
        ScopedValue sv = (ScopedValue)this.buildXMLObject(ScopedValue.TYPE_NAME);
        sv.setValue(this.expectedValue + this.scopeDelimiter + this.expectedScope);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)sv);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        ScopedValue sv = (ScopedValue)this.buildXMLObject(ScopedValue.TYPE_NAME);
        sv.setValue(this.expectedValue);
        sv.setScopeAttributeName(this.scopeAttribute);
        sv.setScope(this.expectedScope);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)sv);
    }

    @Test
    public void testSingleElementUnmarshall() {
        ScopedValue sv = (ScopedValue)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)sv, (String)"Unmarshalled object was null");
        Assert.assertEquals((String)(this.expectedValue + this.scopeDelimiter + this.expectedScope), (String)sv.getValue(), (String)"Scoped value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ScopedValue sv = (ScopedValue)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        sv.setScopeAttributeName(this.scopeAttribute);
        Assert.assertNotNull((Object)sv, (String)"Unmarshalled object was null");
        Assert.assertEquals((String)this.expectedValue, (String)sv.getValue(), (String)"Scoped value");
        Assert.assertEquals((String)this.expectedScope, (String)sv.getScope(), (String)"Scope value");
        Assert.assertEquals((String)this.scopeAttribute, (String)sv.getScopeAttributeName(), (String)"Scope attribute name");
    }
}

