/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.DurablePairwiseIdStore;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPersistentIdDecoder
extends AbstractIdentifiableInitializableComponent
implements NameIDDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredPersistentIdDecoder.class);
    @NonnullAfterInit
    private DurablePairwiseIdStore pidStore;
    @Nullable
    private DataSource dataSource;

    public void setPersistentIdStore(@Nullable DurablePairwiseIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.pidStore = store;
    }

    public void setDataSource(@Nullable DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = source;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.pidStore) {
            if (this.dataSource != null) {
                this.log.debug("Creating JDBCPairwiseIdStore instance around supplied DataSource");
                JDBCPairwiseIdStore newStore = new JDBCPairwiseIdStore();
                newStore.setVerifyDatabase(false);
                newStore.setDataSource(this.dataSource);
                newStore.initialize();
                this.pidStore = newStore;
            }
            if (null == this.pidStore) {
                throw new ComponentInitializationException("PairwiseIdStore cannot be null");
            }
        }
    }

    @Nonnull
    @NotEmpty
    public String decode(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull NameID nameID) throws NameDecoderException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (nameID.getValue() == null) {
            throw new NameDecoderException("Persistent NameID was empty");
        }
        String recipientID = nameID.getSPNameQualifier();
        if (recipientID == null && (recipientID = c14nContext.getRequesterId()) == null) {
            throw new NameDecoderException("SPNameQualifier and requester ID were null");
        }
        String issuerID = nameID.getNameQualifier();
        if (issuerID == null && (issuerID = c14nContext.getResponderId()) == null) {
            throw new NameDecoderException("NameQualifier and responder ID were null");
        }
        try {
            PairwiseId pid = new PairwiseId();
            pid.setIssuerEntityID(issuerID);
            pid.setRecipientEntityID(recipientID);
            pid.setPairwiseId(nameID.getValue());
            pid = this.pidStore.getByIssuedValue(pid);
            if (pid == null || pid.getPrincipalName() == null) {
                this.log.info("No entry found for persistent ID {}", (Object)nameID.getValue());
                return null;
            }
            return pid.getPrincipalName();
        }
        catch (IOException e) {
            this.log.error("I/O error looking up persistent ID", (Throwable)e);
            return null;
        }
    }
}

