/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.List;
import net.shibboleth.idp.saml.metadata.ScopesContainer;
import net.shibboleth.idp.saml.metadata.impl.BaseNodeProcessorTest;
import net.shibboleth.idp.saml.metadata.impl.ScopesNodeProcessor;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class ScopesNodeProcessorTest
extends BaseNodeProcessorTest {
    @Test
    public void noScopes() throws ResolverException {
        EntityDescriptor noScopes = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://noscopes.example.org")}));
        Assert.assertTrue((boolean)noScopes.getObjectMetadata().get(ScopesContainer.class).isEmpty());
        AttributeAuthorityDescriptor aaNoScope = noScopes.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertTrue((boolean)aaNoScope.getObjectMetadata().get(ScopesContainer.class).isEmpty());
        IDPSSODescriptor idpSSONoScope = noScopes.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertTrue((boolean)idpSSONoScope.getObjectMetadata().get(ScopesContainer.class).isEmpty());
    }

    @Test
    public void scopes() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://scopes.example.org")}));
        List entityList = entity.getObjectMetadata().get(ScopesContainer.class);
        Assert.assertEquals((int)entityList.size(), (int)1);
        ScopesContainer entityContainer = (ScopesContainer)entityList.get(0);
        Assert.assertFalse((boolean)entityContainer.matchesScope("flibby"));
        Assert.assertFalse((boolean)entityContainer.matchesScope("entityScope1"));
        Assert.assertFalse((boolean)entityContainer.matchesScope("2entityScope2"));
        Assert.assertTrue((boolean)entityContainer.matchesScope("entityScope"));
        Assert.assertTrue((boolean)entityContainer.matchesScope("entityScope2"));
        IDPSSODescriptor idpSSO = entity.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        List idpSSOList = idpSSO.getObjectMetadata().get(ScopesContainer.class);
        Assert.assertEquals((int)idpSSOList.size(), (int)1);
        ScopesContainer idpSSOContainer = (ScopesContainer)idpSSOList.get(0);
        Assert.assertFalse((boolean)idpSSOContainer.matchesScope("flibby"));
        Assert.assertFalse((boolean)idpSSOContainer.matchesScope("FFFIDPSSOPREregSSScoped"));
        Assert.assertTrue((boolean)idpSSOContainer.matchesScope("FFFIDPSSOPREregSSScope"));
        Assert.assertTrue((boolean)idpSSOContainer.matchesScope("IDPSSOScope2"));
        AttributeAuthorityDescriptor aa = entity.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        List aaList = aa.getObjectMetadata().get(ScopesContainer.class);
        Assert.assertEquals((int)aaList.size(), (int)1);
        ScopesContainer aaContainer = (ScopesContainer)aaList.get(0);
        Assert.assertFalse((boolean)aaContainer.matchesScope("flibby"));
        Assert.assertTrue((boolean)aaContainer.matchesScope("AAScope1"));
        Assert.assertTrue((boolean)aaContainer.matchesScope("AASCOPE2"));
        Assert.assertTrue((boolean)aaContainer.matchesScope("flibbyAASCOPE2flibby"));
    }

    @Override
    protected MetadataNodeProcessor getProcessor() {
        return new ScopesNodeProcessor();
    }
}

