/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIdentifierDecoder;
import net.shibboleth.idp.saml.nameid.impl.NameIdentifierCanonicalization;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIdentifierCanonicalizationTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private NameIDCanonicalizationFlowDescriptor flowDescriptor;
    private NameIdentifierCanonicalization action;
    private SAMLObjectBuilder<NameIdentifier> builder;
    private static final String REQUESTER = "TestRequest";
    private static final String RESPONDER = "TestResp";
    private static final String VALUE_PREFIX = "TestPrefix";
    private static final List<String> formats = Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", null);

    @BeforeClass
    public void initialize() {
        this.builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.prc = new ProfileRequestContext();
        this.flowDescriptor = new NameIDCanonicalizationFlowDescriptor();
        this.flowDescriptor.setId("C14NDesc");
        this.flowDescriptor.setFormats(formats);
        this.flowDescriptor.initialize();
        this.action = new NameIdentifierCanonicalization();
        this.action.setDecoder(new NameIdentifierDecoder(){

            public String decode(SubjectCanonicalizationContext scc, NameIdentifier nameIdentifier) {
                if (NameIdentifierCanonicalizationTest.RESPONDER.equals(scc.getResponderId()) && NameIdentifierCanonicalizationTest.REQUESTER.equals(scc.getRequesterId())) {
                    return NameIdentifierCanonicalizationTest.VALUE_PREFIX + nameIdentifier.getValue();
                }
                return null;
            }
        });
        this.action.initialize();
    }

    private void setSubContext(@Nullable Subject subject, @Nullable String responder, @Nullable String requester) {
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        if (subject != null) {
            scc.setSubject(subject);
        }
        if (requester != null) {
            scc.setRequesterId(requester);
        }
        if (responder != null) {
            scc.setResponderId(responder);
        }
        scc.setAttemptedFlow((SubjectCanonicalizationFlowDescriptor)this.flowDescriptor);
    }

    private NameIdentifier nameId(String value, String format, String nameQualifier) {
        NameIdentifier id = (NameIdentifier)this.builder.buildObject();
        id.setValue(value);
        id.setFormat(format);
        id.setNameQualifier(nameQualifier);
        return id;
    }

    private NameIdentifier nameId(String value, String format) {
        return this.nameId(value, format, RESPONDER);
    }

    @Test
    public void testNoContext() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubjectCanonicalizationContext");
    }

    @Test
    public void testNoPrincipal() {
        Subject subject = new Subject();
        this.setSubContext(subject, null, null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
        Assert.assertNotNull((Object)((SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, false)).getException());
    }

    @Test
    public void testMultiPrincipals() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName")));
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value2", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")));
        this.setSubContext(subject, null, null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
        Assert.assertNotNull((Object)((SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, false)).getException());
    }

    @Test
    public void testWrongFormat() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName")));
        this.setSubContext(subject, RESPONDER, REQUESTER);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
        Assert.assertNotNull((Object)((SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, false)).getException());
    }

    @Test
    public void testWrongRequester() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")));
        this.setSubContext(subject, RESPONDER, RESPONDER);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
    }

    @Test
    public void testWrongResponderNameId() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")));
        this.setSubContext(subject, REQUESTER, REQUESTER);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
    }

    @Test
    public void testWrongResponder() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("value", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", REQUESTER)));
        this.setSubContext(subject, REQUESTER, REQUESTER);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSubject");
    }

    @Test
    public void testSuccess() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo@osu.edu"));
        subject.getPrincipals().add((Principal)new NameIdentifierPrincipal(this.nameId("works", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")));
        this.setSubContext(subject, RESPONDER, REQUESTER);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, false);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"TestPrefixworks");
    }
}

