/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Collections;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.impl.ComputedPairwiseIdStore;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.nameid.impl.PersistentSAML2NameIDGenerator;
import net.shibboleth.idp.testing.DatabaseTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PersistentSAML2NameIDGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private static final String RESULT = "Vl6z6K70iLc4AuBoNeb59Dj1rGw=";
    private static final byte[] salt = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final String INIT_FILE = "/net/shibboleth/idp/saml/impl/nameid/StoredIdStore.sql";
    public static final String DELETE_FILE = "/net/shibboleth/idp/saml/impl/nameid/DeleteStore.sql";
    private DataSource testSource;
    private ProfileRequestContext prc;
    private PersistentSAML2NameIDGenerator generator;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.testSource = DatabaseTestingSupport.GetMockDataSource((String)INIT_FILE, (String)"StoredIDDataConnectorStore");
        this.prc = new RequestContextBuilder().setInboundMessageIssuer("https://sp.example.org/sp").setOutboundMessageIssuer("https://idp.example.org/idp").buildProfileRequestContext();
        this.generator = new PersistentSAML2NameIDGenerator();
        this.generator.setId("test");
        this.generator.setOmitQualifiers(false);
    }

    @AfterMethod
    public void tearDown() {
        DatabaseTestingSupport.InitializeDataSource((String)DELETE_FILE, (DataSource)this.testSource);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInvalidConfig() throws ComponentInitializationException {
        ComputedPairwiseIdStore strategy = new ComputedPairwiseIdStore();
        strategy.setSalt(salt);
        strategy.initialize();
        this.generator.initialize();
        this.generator.setPersistentIdStore((PairwiseIdStore)strategy);
        this.generator.initialize();
    }

    @Test
    public void testNoResponderId() throws Exception {
        this.generator.setPersistentIdStore((PairwiseIdStore)new ComputedPairwiseIdStore());
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        Assert.assertNull((Object)this.generator.generate(new ProfileRequestContext(), "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
    }

    @Test
    public void testNoRequesterId() throws Exception {
        this.generator.setPersistentIdStore((PairwiseIdStore)new ComputedPairwiseIdStore());
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyId(null);
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
    }

    @Test
    public void testNoSubject() throws Exception {
        this.generator.setPersistentIdStore((PairwiseIdStore)new ComputedPairwiseIdStore());
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
    }

    @Test
    public void testNoSource() throws Exception {
        this.generator.setPersistentIdStore((PairwiseIdStore)new ComputedPairwiseIdStore());
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(new IdPAttribute("SOURCE")));
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
    }

    @Test
    public void testComputedId() throws Exception {
        ComputedPairwiseIdStore strategy = new ComputedPairwiseIdStore();
        strategy.setSalt(salt);
        strategy.initialize();
        this.generator.setPersistentIdStore((PairwiseIdStore)strategy);
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id.getValue(), (String)RESULT);
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
    }

    @Test
    public void testStoredId() throws Exception {
        this.generator.setDataSource(this.testSource);
        this.testStoredIdLogic();
    }

    @Test
    public void testComputedAndStoredId() throws Exception {
        ComputedPairwiseIdStore strategy = new ComputedPairwiseIdStore();
        strategy.setSalt(salt);
        strategy.initialize();
        JDBCPairwiseIdStore store = new JDBCPairwiseIdStore();
        store.setDataSource(this.testSource);
        store.setInitialValueStore((PairwiseIdStore)strategy);
        store.initialize();
        this.generator.setPersistentIdStore((PairwiseIdStore)store);
        this.testComputedAndStoredIdLogic();
        PairwiseId pid = new PairwiseId();
        pid.setIssuerEntityID("https://idp.example.org/idp");
        pid.setRecipientEntityID("https://sp.example.org/sp");
        pid.setPairwiseId(RESULT);
        store.deactivate(pid);
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotEquals((Object)id.getValue(), (Object)RESULT);
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
    }

    private void testStoredIdLogic() throws Exception {
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
        String storedvalue = id.getValue();
        id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id.getValue(), (String)storedvalue);
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        NameIDPolicy policy = (NameIDPolicy)XMLObjectSupport.buildXMLObject((QName)NameIDPolicy.DEFAULT_ELEMENT_NAME);
        request.setNameIDPolicy(policy);
        policy.setSPNameQualifier("https://affiliation.org");
        this.prc.getInboundMessageContext().setMessage((Object)request);
        id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://affiliation.org");
        storedvalue = id.getValue();
        id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id.getValue(), (String)storedvalue);
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://affiliation.org");
    }

    private void testComputedAndStoredIdLogic() throws Exception {
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id.getValue(), (String)RESULT);
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
        id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id.getValue(), (String)RESULT);
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
    }
}

