/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Predicates;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.idp.saml.profile.impl.PopulateBindingAndEndpointContexts;
import net.shibboleth.idp.saml.profile.impl.SAMLVerificationLookupStrategy;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.impl.DefaultEndpointResolver;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class PopulateBindingAndEndpointContextsTest
extends XMLObjectBaseTestCase {
    private static final String RELAY_STATE = "foo";
    private static final String LOCATION = "https://sp.example.org/ACS";
    private static final String LOCATION_POST = "https://sp.example.org/POST2";
    private static final String LOCATION_ART = "https://sp.example.org/Art2";
    private RequestContext rc;
    private BrowserSSOProfileConfiguration profileConfig;
    private ProfileRequestContext prc;
    private PopulateBindingAndEndpointContexts action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        request.setAssertionConsumerServiceURL(LOCATION_POST);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        this.profileConfig = new BrowserSSOProfileConfiguration();
        this.rc = new RequestContextBuilder().setInboundMessage((Object)request).setRelyingPartyProfileConfigurations(Collections.singletonList(this.profileConfig)).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        ((SAMLBindingContext)this.prc.getInboundMessageContext().getSubcontext(SAMLBindingContext.class, true)).setRelayState(RELAY_STATE);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setVerificationLookupStrategy((Function)new SAMLVerificationLookupStrategy());
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyIdContextTree(this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true));
        this.action = new PopulateBindingAndEndpointContexts();
        this.action.setEndpointResolver((EndpointResolver)new DefaultEndpointResolver());
        this.action.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        ArrayList<BindingDescriptor> bindings = new ArrayList<BindingDescriptor>();
        bindings.add(new BindingDescriptor());
        ((BindingDescriptor)bindings.get(0)).setId("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        ((BindingDescriptor)bindings.get(0)).initialize();
        this.action.setBindingDescriptorsLookupStrategy(FunctionSupport.constant(bindings));
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoResolver() throws ComponentInitializationException {
        PopulateBindingAndEndpointContexts badaction = new PopulateBindingAndEndpointContexts();
        badaction.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testBadEndpointType() throws ComponentInitializationException {
        PopulateBindingAndEndpointContexts badaction = new PopulateBindingAndEndpointContexts();
        badaction.setEndpointType(AuthnRequest.DEFAULT_ELEMENT_NAME);
        badaction.initialize();
    }

    @Test
    public void testNoOutboundContext() {
        this.prc.setOutboundMessageContext(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoBindings() throws ComponentInitializationException {
        BindingDescriptor binding = new BindingDescriptor();
        binding.setId("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        binding.setActivationCondition((Predicate)Predicates.alwaysFalse());
        binding.initialize();
        PopulateBindingAndEndpointContexts badaction = new PopulateBindingAndEndpointContexts();
        badaction.setEndpointResolver((EndpointResolver)new DefaultEndpointResolver());
        badaction.setBindingDescriptorsLookupStrategy(FunctionSupport.constant(Collections.singletonList(binding)));
        badaction.initialize();
        Event event = badaction.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testNoMetadata() {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLEndpointContext epCtx = (SAMLEndpointContext)((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, false)).getSubcontext(SAMLEndpointContext.class, false);
        Assert.assertNotNull((Object)epCtx);
        Assert.assertNotNull((Object)epCtx.getEndpoint());
        Assert.assertEquals((String)epCtx.getEndpoint().getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)epCtx.getEndpoint().getLocation(), (String)LOCATION_POST);
    }

    @Test
    public void testNoEndpoints() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPNoEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testSignedNoEndpoints() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPNoEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
        this.profileConfig.setSkipEndpointValidationWhenSigned(true);
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
        this.profileConfig.setSkipEndpointValidationWhenSigned(false);
        ((SAMLBindingContext)this.prc.getInboundMessageContext().getSubcontext(SAMLBindingContext.class)).setHasBindingSignature(true);
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
        this.profileConfig.setSkipEndpointValidationWhenSigned(true);
        ((SAMLBindingContext)this.prc.getInboundMessageContext().getSubcontext(SAMLBindingContext.class)).setHasBindingSignature(true);
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    @Test
    public void testBadLocation() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(LOCATION);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testBadBinding() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testUnsupportedBinding() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(LOCATION_ART);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testBadIndex() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceIndex(Integer.valueOf(10));
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(null);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testSynchronous() throws ComponentInitializationException {
        ((SAMLBindingContext)this.prc.getInboundMessageContext().getSubcontext(SAMLBindingContext.class)).setBindingUri("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        BindingDescriptor binding = new BindingDescriptor();
        binding.setId("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        binding.setSynchronous(true);
        binding.initialize();
        PopulateBindingAndEndpointContexts badaction = new PopulateBindingAndEndpointContexts();
        badaction.setEndpointResolver((EndpointResolver)new DefaultEndpointResolver());
        badaction.setBindingDescriptorsLookupStrategy(FunctionSupport.constant(Collections.singletonList(binding)));
        badaction.initialize();
        Event event = badaction.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        Assert.assertSame((Object)binding, (Object)bindingCtx.getBindingDescriptor());
    }

    @Test
    public void testInMetadata() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLEndpointContext epCtx = (SAMLEndpointContext)((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, false)).getSubcontext(SAMLEndpointContext.class, false);
        Assert.assertNotNull((Object)epCtx);
        Assert.assertNotNull((Object)epCtx.getEndpoint());
        Assert.assertEquals((String)epCtx.getEndpoint().getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)epCtx.getEndpoint().getLocation(), (String)LOCATION_POST);
    }

    @Test
    public void testIndexInMetadata() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceIndex(Integer.valueOf(2));
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(null);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLEndpointContext epCtx = (SAMLEndpointContext)((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, false)).getSubcontext(SAMLEndpointContext.class, false);
        Assert.assertNotNull((Object)epCtx);
        Assert.assertNotNull((Object)epCtx.getEndpoint());
        Assert.assertEquals((String)epCtx.getEndpoint().getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)epCtx.getEndpoint().getLocation(), (String)LOCATION_POST);
    }

    @Test
    public void testIndexUnsupportedBinding() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceIndex(Integer.valueOf(3));
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(null);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"EndpointResolutionFailed");
    }

    @Test
    public void testDefault() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setAssertionConsumerServiceURL(null);
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setProtocolBinding(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLEndpointContext epCtx = (SAMLEndpointContext)((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, false)).getSubcontext(SAMLEndpointContext.class, false);
        Assert.assertNotNull((Object)epCtx);
        Assert.assertNotNull((Object)epCtx.getEndpoint());
        Assert.assertEquals((String)epCtx.getEndpoint().getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)epCtx.getEndpoint().getLocation(), (String)LOCATION_POST.replace("POST2", "POST"));
    }

    @Test
    public void testSAML1InMetadata() throws UnmarshallingException {
        EntityDescriptor entity = this.loadMetadata("/net/shibboleth/idp/saml/impl/profile/SPWithEndpoints.xml");
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor((RoleDescriptor)entity.getSPSSODescriptor("required"));
        ((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).addSubcontext((BaseContext)mdCtx);
        IdPInitiatedSSORequest saml1Request = new IdPInitiatedSSORequest(RELAY_STATE, LOCATION_POST, null, null);
        this.prc.getInboundMessageContext().setMessage((Object)saml1Request);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertNotNull((Object)bindingCtx.getBindingDescriptor());
        Assert.assertEquals((String)bindingCtx.getRelayState(), (String)RELAY_STATE);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLEndpointContext epCtx = (SAMLEndpointContext)((SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, false)).getSubcontext(SAMLEndpointContext.class, false);
        Assert.assertNotNull((Object)epCtx);
        Assert.assertNotNull((Object)epCtx.getEndpoint());
        Assert.assertEquals((String)epCtx.getEndpoint().getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)epCtx.getEndpoint().getLocation(), (String)LOCATION_POST);
    }

    @Nonnull
    private EntityDescriptor loadMetadata(@Nonnull @NotEmpty String path) throws UnmarshallingException {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource(path);
            Document doc = parserPool.parse((InputStream)new FileInputStream(new File(url.toURI())));
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(doc.getDocumentElement());
            return (EntityDescriptor)unmarshaller.unmarshall(doc.getDocumentElement());
        }
        catch (FileNotFoundException | URISyntaxException | XMLParserException e) {
            throw new UnmarshallingException((Exception)e);
        }
    }
}

