/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML1AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML1StringAttributeTranscoder;
import net.shibboleth.idp.saml.saml1.profile.SAML1ActionTestingSupport;
import net.shibboleth.idp.saml.saml1.profile.impl.AddAttributeStatementToAssertion;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Response;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAttributeStatementToAssertionTest
extends OpenSAMLInitBaseTestCase {
    private static final String MY_NAMESPACE = "myNamespace";
    private static final String MY_NAME_1 = "myName1";
    private static final String MY_NAME_2 = "myName2";
    private static final String MY_ALTNAME_1 = "myAltName1";
    private static final String MY_VALUE_1 = "myValue1";
    private static final String MY_VALUE_2 = "myValue2";
    private RequestContext rc;
    private ProfileRequestContext prc;
    private AddAttributeStatementToAssertion action;
    private AttributeTranscoderRegistryImpl registry;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(AttributeDesignator.class, (Function)new AbstractSAML1AttributeTranscoder.NamingFunction())));
        SAML1StringAttributeTranscoder transcoder = new SAML1StringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, String> rule1_1 = new HashMap<String, String>();
        rule1_1.put("id", MY_NAME_1);
        rule1_1.put("transcoder", (String)transcoder);
        rule1_1.put("saml1.name", MY_NAME_1);
        rule1_1.put("saml1.namespace", MY_NAMESPACE);
        HashMap<String, String> rule1_2 = new HashMap<String, String>();
        rule1_2.put("id", MY_NAME_1);
        rule1_2.put("transcoder", (String)transcoder);
        rule1_2.put("saml1.name", MY_ALTNAME_1);
        rule1_2.put("saml1.namespace", MY_NAMESPACE);
        HashMap<String, String> rule2_1 = new HashMap<String, String>();
        rule2_1.put("id", MY_NAME_2);
        rule2_1.put("transcoder", (String)transcoder);
        rule2_1.put("saml1.name", MY_NAME_2);
        rule2_1.put("saml1.namespace", MY_NAMESPACE);
        HashMap<String, String> rule2_2 = new HashMap<String, String>();
        rule2_2.put("id", MY_NAME_2);
        rule2_2.put("transcoder", (String)transcoder);
        rule2_2.put("saml1.name", MY_ALTNAME_1);
        rule2_2.put("saml1.namespace", MY_NAMESPACE);
        this.registry.setTranscoderRegistry(Arrays.asList(new TranscodingRule(rule1_1), new TranscodingRule(rule1_2), new TranscodingRule(rule2_1), new TranscodingRule(rule2_2)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
        this.action = new AddAttributeStatementToAssertion();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)this.registry));
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoOutboundContext() throws Exception {
        this.prc.setOutboundMessageContext(null);
        AttributeContext attribCtx = this.buildAttributeContext();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoAttributeContext() throws Exception {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testNoAttributes() throws Exception {
        AttributeContext attribCtx = new AttributeContext();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testIgnoreAttributeEncodingErrors() throws Exception {
        AttributeTranscoderRegistryImpl localregistry = new AttributeTranscoderRegistryImpl();
        localregistry.setId("test");
        localregistry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(AttributeDesignator.class, (Function)new AbstractSAML1AttributeTranscoder.NamingFunction())));
        MockSAML1StringAttributeTranscoder transcoder = new MockSAML1StringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, Object> rule = new HashMap<String, Object>();
        rule.put("id", MY_NAME_1);
        rule.put("transcoder", (Object)transcoder);
        rule.put("saml1.name", MY_NAME_1);
        rule.put("saml1.namespace", MY_NAMESPACE);
        localregistry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(rule)));
        localregistry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        localregistry.initialize();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)localregistry));
        IdPAttribute attribute = new IdPAttribute(MY_NAME_1);
        attribute.setValues(Arrays.asList(new StringAttributeValue(MY_VALUE_1)));
        AttributeContext attribCtx = new AttributeContext();
        attribCtx.setIdPAttributes(Arrays.asList(attribute));
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.setIgnoringUnencodableAttributes(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void failOnAttributeEncodingErrors() throws Exception {
        AttributeTranscoderRegistryImpl localregistry = new AttributeTranscoderRegistryImpl();
        localregistry.setId("test");
        localregistry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(AttributeDesignator.class, (Function)new AbstractSAML1AttributeTranscoder.NamingFunction())));
        MockSAML1StringAttributeTranscoder transcoder = new MockSAML1StringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, Object> rule = new HashMap<String, Object>();
        rule.put("id", MY_NAME_1);
        rule.put("transcoder", (Object)transcoder);
        rule.put("saml1.name", MY_NAME_1);
        rule.put("saml1.namespace", MY_NAMESPACE);
        localregistry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(rule)));
        localregistry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        localregistry.initialize();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)localregistry));
        IdPAttribute attribute = new IdPAttribute(MY_NAME_1);
        attribute.setValues(Arrays.asList(new StringAttributeValue(MY_VALUE_1)));
        AttributeContext attribCtx = new AttributeContext();
        attribCtx.setIdPAttributes(Arrays.asList(attribute));
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.setIgnoringUnencodableAttributes(false);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"UnableToEncodeAttribute");
    }

    @Test
    public void testAddedAttributeStatement() throws Exception {
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        AttributeContext attribCtx = this.buildAttributeContext();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.setStatementInOwnAssertion(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)2);
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getAttributeStatements().isEmpty()) continue;
            Assert.assertNotNull((Object)assertion.getAttributeStatements());
            Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)1);
            AttributeStatement attributeStatement = (AttributeStatement)assertion.getAttributeStatements().get(0);
            this.testAttributeStatement(attributeStatement);
        }
    }

    @Test
    public void testAssertionInResponse() throws Exception {
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        AttributeContext attribCtx = this.buildAttributeContext();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertNotNull((Object)assertion.getAttributeStatements());
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)1);
        AttributeStatement attributeStatement = (AttributeStatement)assertion.getAttributeStatements().get(0);
        this.testAttributeStatement(attributeStatement);
    }

    @Test
    public void testNoAssertionInResponse() throws Exception {
        AttributeContext attribCtx = this.buildAttributeContext();
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attribCtx);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertNotNull((Object)assertion.getAttributeStatements());
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)1);
        AttributeStatement attributeStatement = (AttributeStatement)assertion.getAttributeStatements().get(0);
        this.testAttributeStatement(attributeStatement);
    }

    private AttributeContext buildAttributeContext() throws ComponentInitializationException {
        IdPAttribute attribute1 = new IdPAttribute(MY_NAME_1);
        attribute1.setValues(Arrays.asList(new StringAttributeValue(MY_VALUE_1)));
        IdPAttribute attribute2 = new IdPAttribute(MY_NAME_2);
        attribute2.setValues(Collections.singletonList(new StringAttributeValue(MY_VALUE_2)));
        AttributeContext attribCtx = new AttributeContext();
        attribCtx.setIdPAttributes(Arrays.asList(attribute1, attribute2));
        return attribCtx;
    }

    private void testAttributeStatement(AttributeStatement attributeStatement) {
        Assert.assertNotNull((Object)attributeStatement.getAttributes());
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)3);
        boolean one = false;
        boolean altone = false;
        boolean two = false;
        for (Attribute samlAttr : attributeStatement.getAttributes()) {
            XMLObject xmlObject;
            if (samlAttr.getAttributeName().equals(MY_NAME_1)) {
                Assert.assertEquals((int)samlAttr.getAttributeValues().size(), (int)1);
                xmlObject = (XMLObject)samlAttr.getAttributeValues().get(0);
                Assert.assertEquals((String)((XSStringImpl)xmlObject).getValue(), (String)MY_VALUE_1);
                one = true;
                continue;
            }
            if (samlAttr.getAttributeName().equals(MY_NAME_2)) {
                Assert.assertEquals((int)samlAttr.getAttributeValues().size(), (int)1);
                xmlObject = (XMLObject)samlAttr.getAttributeValues().get(0);
                Assert.assertEquals((String)((XSStringImpl)xmlObject).getValue(), (String)MY_VALUE_2);
                altone = true;
                continue;
            }
            if (samlAttr.getAttributeName().equals(MY_ALTNAME_1)) {
                Assert.assertEquals((int)samlAttr.getAttributeValues().size(), (int)2);
                String val1 = ((XSStringImpl)samlAttr.getAttributeValues().get(0)).getValue();
                String val2 = ((XSStringImpl)samlAttr.getAttributeValues().get(1)).getValue();
                if (val1.equals(MY_VALUE_1)) {
                    Assert.assertEquals((String)val2, (String)MY_VALUE_2);
                    two = true;
                    continue;
                }
                if (!val2.equals(MY_VALUE_1)) continue;
                Assert.assertEquals((String)val1, (String)MY_VALUE_2);
                two = true;
                continue;
            }
            Assert.fail((String)"Incorrect attribute name.");
        }
        if (!(one && altone && two)) {
            Assert.fail((String)"Missing attribute or value");
        }
    }

    private class MockSAML1StringAttributeTranscoder
    extends SAML1StringAttributeTranscoder {
        private MockSAML1StringAttributeTranscoder() {
        }

        @Nullable
        public Attribute encode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends AttributeDesignator> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
            throw new AttributeEncodingException("Always thrown.");
        }
    }
}

