/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.AddAuthnStatementToAssertionFromInboundAssertionToken;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class AddAuthnStatementToAssertionFromInboundAssertionTokenTest
extends OpenSAMLInitBaseTestCase {
    private AddAuthnStatementToAssertionFromInboundAssertionToken action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private Assertion delegatedAssertion;
    private AuthnStatement delegatedAuthnStatement;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedAuthnStatement = SAML2ActionTestingSupport.buildAuthnStatement();
        this.delegatedAssertion.getAuthnStatements().add(this.delegatedAuthnStatement);
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        this.action = new AddAuthnStatementToAssertionFromInboundAssertionToken();
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, MarshallingException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assertion newAssertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Assert.assertFalse((boolean)newAssertion.getAuthnStatements().isEmpty());
        Diff diff = DiffBuilder.compare((Object)XMLObjectSupport.marshall((XMLObject)this.delegatedAuthnStatement)).withTest((Object)XMLObjectSupport.marshall((XMLObject)((XMLObject)newAssertion.getAuthnStatements().get(0)))).checkForIdentical().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    @Test
    public void testActivationCondition() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testNoLibertyContext() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoDelegatedAssertion() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).setAttestedToken(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoDelegatedAuthnStatement() throws ComponentInitializationException {
        this.delegatedAssertion.getAuthnStatements().clear();
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoAssertionToModify() throws ComponentInitializationException {
        this.action.setAssertionLookupStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidMessageContext");
    }
}

