/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationRequest;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DecorateDelegatedAssertion;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.openliberty.xmltooling.disco.MetadataAbstract;
import org.openliberty.xmltooling.disco.ProviderID;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.disco.ServiceType;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.soap.wsaddressing.EndpointReference;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class DecorateDelegatedAssertionTest
extends OpenSAMLInitBaseTestCase {
    private boolean print = false;
    private String ssosURL = "https://idp.example.org:8443/idp/profile/IDWSF/SSOS";
    private AuthnRequest authnRequest;
    private Response response;
    private Assertion assertion;
    private Element origAssertionDOM;
    private BrowserSSOProfileConfiguration browserSSOProfileConfig;
    private List<ProfileConfiguration> profileConfigs;
    private List<PublicKey> publicKeys = new ArrayList<PublicKey>();
    private int numKeys = 3;
    private List<Credential> credentials;
    private DecorateDelegatedAssertion action;
    private MockServletContext servletContext;
    private MockHttpServletRequest servletRequest;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private DelegationContext delegationContext;

    public DecorateDelegatedAssertionTest() throws NoSuchAlgorithmException, NoSuchProviderException {
        for (int i = 0; i < this.numKeys; ++i) {
            this.publicKeys.add(KeySupport.generateKeyPair((String)"RSA", (int)2048, null).getPublic());
        }
        this.credentials = new ArrayList<Credential>();
        for (PublicKey publicKey : this.publicKeys) {
            this.credentials.add((Credential)CredentialSupport.getSimpleCredential((PublicKey)publicKey, null));
        }
    }

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException, MarshallingException {
        this.servletContext = new MockServletContext();
        this.servletContext.setContextPath("/idp");
        this.servletRequest = new MockHttpServletRequest((ServletContext)this.servletContext);
        this.servletRequest.setScheme("https");
        this.servletRequest.setServerName("idp.example.org");
        this.servletRequest.setServerPort(443);
        this.servletRequest.setRequestURI("/idp/profile/SAML2/Redirect/SSO");
        this.servletRequest.setContextPath("/idp");
        this.authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.authnRequest.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://sp.example.org"));
        this.response = SAML2ActionTestingSupport.buildResponse();
        this.response.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://idp.example.org"));
        this.assertion = SAML2ActionTestingSupport.buildAssertion();
        this.assertion.setID("assertion");
        this.assertion.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://idp.example.org"));
        this.assertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        this.assertion.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        this.assertion.getAttributeStatements().add(SAML2ActionTestingSupport.buildAttributeStatement());
        this.response.getAssertions().add(this.assertion);
        this.browserSSOProfileConfig = new BrowserSSOProfileConfiguration();
        this.profileConfigs = new ArrayList<ProfileConfiguration>();
        this.profileConfigs.add((ProfileConfiguration)this.browserSSOProfileConfig);
        this.rc = new RequestContextBuilder().setServletContext((ServletContext)this.servletContext).setHttpRequest((HttpServletRequest)this.servletRequest).setInboundMessage((Object)this.authnRequest).setOutboundMessage((Object)this.response).setRelyingPartyProfileConfigurations(this.profileConfigs).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        RelyingPartyContext rpcContext = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)rpcContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId("http://sp.example.org");
        peerContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        rpcContext.setRelyingPartyIdContextTree((BaseContext)peerContext);
        this.action = new DecorateDelegatedAssertion();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return DecorateDelegatedAssertionTest.this.servletRequest;
            }
        });
        this.action.setLibertySSOSEndpointURL(this.ssosURL);
        this.action.setKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager());
        this.delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class, true);
        this.delegationContext.setIssuingDelegatedAssertion(true);
        this.delegationContext.setDelegationRequested(DelegationRequest.REQUESTED_REQUIRED);
        this.delegationContext.setSubjectConfirmationCredentials(this.credentials);
        this.origAssertionDOM = XMLObjectSupport.marshall((XMLObject)this.assertion);
        this.assertion.releaseDOM();
        this.assertion.releaseChildrenDOM(true);
    }

    @BeforeMethod(dependsOnMethods={"setUp"})
    protected void printBefore() {
        if (this.print) {
            System.out.println(this.prettyPrint((XMLObject)this.authnRequest));
            System.out.println(this.prettyPrint((XMLObject)this.response));
        }
    }

    @AfterMethod
    protected void printAfter() {
        if (this.print) {
            System.out.println(this.prettyPrint((XMLObject)this.response));
        }
    }

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void testNotInitialized() throws Exception {
        this.action.execute(this.rc);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoConfiguredEndpointNoStrategy() throws Exception {
        this.action = new DecorateDelegatedAssertion();
        this.action.setLibertySSOSEndpointURL(null);
        this.action.setLibertySSOSEndpointURLLookupStrategy(null);
        this.action.setKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager());
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoKeyInfoManager() throws Exception {
        this.action = new DecorateDelegatedAssertion();
        this.action.setLibertySSOSEndpointURL(this.ssosURL);
        this.action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
        this.testUndecoratedAssertion();
    }

    @Test
    public void testNoAssertions() throws Exception {
        this.response.getAssertions().clear();
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testUndecoratedAssertion();
    }

    @Test
    public void testActivationCondition() throws Exception {
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.delegationContext.setSubjectConfirmationCredentials(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testUndecoratedAssertion();
    }

    @Test
    public void testNoDelegationContext() throws Exception {
        this.prc.removeSubcontext(DelegationContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testUndecoratedAssertion();
    }

    @Test
    public void testDelegationNotActive() throws Exception {
        this.delegationContext.setIssuingDelegatedAssertion(false);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testUndecoratedAssertion();
    }

    @Test
    public void testDelegationActive() throws Exception {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testDecoratedAssertion();
    }

    @Test
    public void testDelegationActiveNoCredentials() throws Exception {
        this.delegationContext.setSubjectConfirmationCredentials(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
        this.testUndecoratedAssertion();
    }

    @Test
    public void testEndpointViaDefaultStrategy() throws Exception {
        this.action.setLibertySSOSEndpointURL(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        this.testDecoratedAssertion();
    }

    @Test
    public void testEndpointStrategyProducesNull() throws Exception {
        this.action.setLibertySSOSEndpointURL(null);
        this.action.setLibertySSOSEndpointURLLookupStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
        this.testUndecoratedAssertion();
    }

    @Test
    public void testDefaultEndpointStrategy() {
        Assert.assertEquals((String)this.servletRequest.getRequestURL().toString(), (String)"https://idp.example.org/idp/profile/SAML2/Redirect/SSO");
        Pair input = new Pair((Object)this.prc, (Object)this.servletRequest);
        DecorateDelegatedAssertion.LibertySSOSEndpointURLStrategy strategy = new DecorateDelegatedAssertion.LibertySSOSEndpointURLStrategy();
        Assert.assertEquals((String)strategy.apply(input), (String)this.ssosURL);
    }

    private String prettyPrint(XMLObject xmlObject) {
        try {
            Element element = XMLObjectSupport.marshall((XMLObject)xmlObject);
            return SerializeSupport.prettyPrintXML((Node)element);
        }
        catch (MarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    private void testUndecoratedAssertion() throws MarshallingException {
        Element currentAssertionDOM = XMLObjectSupport.marshall((XMLObject)this.assertion);
        this.assertion.releaseDOM();
        this.assertion.releaseChildrenDOM(true);
        Assert.assertNotSame((Object)this.origAssertionDOM.getOwnerDocument(), (Object)currentAssertionDOM.getOwnerDocument());
        Diff diff = DiffBuilder.compare((Object)this.origAssertionDOM).withTest((Object)currentAssertionDOM).checkForIdentical().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    private void testDecoratedAssertion() throws MarshallingException {
        Element currentAssertionDOM = XMLObjectSupport.marshall((XMLObject)this.assertion);
        this.assertion.releaseDOM();
        this.assertion.releaseChildrenDOM(true);
        Assert.assertNotSame((Object)this.origAssertionDOM.getOwnerDocument(), (Object)currentAssertionDOM.getOwnerDocument());
        Diff diff = DiffBuilder.compare((Object)this.origAssertionDOM).withTest((Object)currentAssertionDOM).checkForIdentical().build();
        Assert.assertTrue((boolean)diff.hasDifferences(), (String)diff.toString());
        Assert.assertNotNull((Object)this.assertion.getSubject().getSubjectConfirmations());
        Assert.assertEquals((int)this.assertion.getSubject().getSubjectConfirmations().size(), (int)1);
        SubjectConfirmation sc = (SubjectConfirmation)this.assertion.getSubject().getSubjectConfirmations().get(0);
        Assert.assertEquals((String)sc.getMethod(), (String)"urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        Assert.assertNotNull((Object)sc.getNameID());
        Assert.assertEquals((String)sc.getNameID().getValue(), (String)"http://sp.example.org");
        Assert.assertTrue((boolean)(sc.getSubjectConfirmationData() instanceof KeyInfoConfirmationDataType));
        KeyInfoConfirmationDataType confData = (KeyInfoConfirmationDataType)sc.getSubjectConfirmationData();
        Assert.assertEquals((int)confData.getKeyInfos().size(), (int)this.numKeys);
        Assert.assertEquals((int)((KeyInfo)confData.getKeyInfos().get(0)).getKeyValues().size(), (int)1);
        Assert.assertNotNull((Object)this.assertion.getConditions());
        Assert.assertEquals((int)this.assertion.getConditions().getAudienceRestrictions().size(), (int)1);
        Assert.assertTrue((((AudienceRestriction)this.assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().size() > 0 ? 1 : 0) != 0);
        boolean sawAudience = false;
        for (Object audience : ((AudienceRestriction)this.assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences()) {
            if (!Objects.equals(audience.getURI(), "http://idp.example.org")) continue;
            sawAudience = true;
        }
        Assert.assertTrue((boolean)sawAudience);
        Assert.assertEquals((int)this.assertion.getAttributeStatements().size(), (int)1);
        Attribute ssosAttrib = null;
        for (Attribute attrib : ((AttributeStatement)this.assertion.getAttributeStatements().get(0)).getAttributes()) {
            if (!Objects.equals(attrib.getName(), "urn:liberty:ssos:2006-08")) continue;
            ssosAttrib = attrib;
            break;
        }
        Assert.assertNotNull(ssosAttrib);
        Assert.assertEquals((int)ssosAttrib.getAttributeValues().size(), (int)1);
        Assert.assertTrue((boolean)(ssosAttrib.getAttributeValues().get(0) instanceof XSAny));
        XSAny attribValue = (XSAny)ssosAttrib.getAttributeValues().get(0);
        Assert.assertEquals((int)attribValue.getUnknownXMLObjects(EndpointReference.ELEMENT_NAME).size(), (int)1);
        EndpointReference epr = (EndpointReference)attribValue.getUnknownXMLObjects(EndpointReference.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)epr.getAddress());
        Assert.assertEquals((String)epr.getAddress().getURI(), (String)this.ssosURL);
        Assert.assertNotNull((Object)epr.getMetadata());
        Assert.assertEquals((int)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_ABSTRACT_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((MetadataAbstract)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_ABSTRACT_ELEMENT_NAME).get(0)).getValue(), (String)"ID-WSF Single Sign-On Service");
        Assert.assertEquals((int)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_SERVICE_TYPE_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((ServiceType)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_SERVICE_TYPE_ELEMENT_NAME).get(0)).getValue(), (String)"urn:liberty:ssos:2006-08");
        Assert.assertEquals((int)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_PROVIDERID_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((ProviderID)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_PROVIDERID_ELEMENT_NAME).get(0)).getValue(), (String)"http://idp.example.org");
        Assert.assertEquals((int)epr.getMetadata().getUnknownXMLObjects(Framework.DEFAULT_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((Framework)epr.getMetadata().getUnknownXMLObjects(Framework.DEFAULT_ELEMENT_NAME).get(0)).getVersion(), (String)"2.0");
        Assert.assertEquals((int)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_SECURITY_CONTEXT_ELEMENT_NAME).size(), (int)1);
        SecurityContext secContext = (SecurityContext)epr.getMetadata().getUnknownXMLObjects(LibertyConstants.DISCO_SECURITY_CONTEXT_ELEMENT_NAME).get(0);
        Assert.assertEquals((int)secContext.getSecurityMechIDs().size(), (int)1);
        Assert.assertEquals((String)((SecurityMechID)secContext.getSecurityMechIDs().get(0)).getValue(), (String)"urn:liberty:security:2005-02:ClientTLS:peerSAMLV2");
        Assert.assertEquals((int)secContext.getTokens().size(), (int)1);
        Assert.assertEquals((String)((Token)secContext.getTokens().get(0)).getRef(), (String)"#assertion");
        Assert.assertEquals((String)((Token)secContext.getTokens().get(0)).getUsage(), (String)"urn:liberty:security:tokenusage:2006-08:SecurityToken");
    }
}

