/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.FinalizeSAMLTokenProcessing;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FinalizeSAMLTokenProcessingTest
extends OpenSAMLInitBaseTestCase {
    private FinalizeSAMLTokenProcessing action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private SubjectCanonicalizationContext c14NContext;
    private String expectedPrincipalName = "morpheus";

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.c14NContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        this.c14NContext.setPrincipalName(this.expectedPrincipalName);
        this.action = new FinalizeSAMLTokenProcessing();
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectCanonicalizationContext.class));
        SubjectContext subjectContext = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectContext);
        Assert.assertEquals((String)subjectContext.getPrincipalName(), (String)this.expectedPrincipalName);
    }

    @Test
    public void testNoC14NContext() throws ComponentInitializationException {
        this.prc.removeSubcontext(SubjectCanonicalizationContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSubjectCanonicalizationContext");
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
    }

    @Test
    public void testNoPrincipalName() throws ComponentInitializationException {
        ((SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class)).setPrincipalName(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSubjectCanonicalizationContext");
        Assert.assertNotNull((Object)this.prc.getSubcontext(SubjectCanonicalizationContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
    }
}

