/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.ProcessAssertionsForAuthentication;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessAssertionsForAuthenticationTest
extends OpenSAMLInitBaseTestCase {
    private ProcessAssertionsForAuthentication action;
    private ProfileRequestContext prc;
    private ProfileRequestContext prcInner;
    private SAMLAuthnContext samlAuthnContext;
    private Response samlResponse;
    private MockHttpServletRequest httpRequest;
    private MockHttpServletResponse httpResponse;

    @BeforeMethod
    public void beforeMethod() {
        this.httpRequest = new MockHttpServletRequest();
        this.httpResponse = new MockHttpServletResponse();
        this.action = new ProcessAssertionsForAuthentication();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return ProcessAssertionsForAuthenticationTest.this.httpRequest;
            }
        });
        this.action.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return ProcessAssertionsForAuthenticationTest.this.httpResponse;
            }
        });
        this.samlResponse = SAML2ActionTestingSupport.buildResponse();
        this.prcInner = new RequestContextBuilder().setInboundMessage((Object)this.samlResponse).buildProfileRequestContext();
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        AuthenticationContext authnContext = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        this.samlAuthnContext = new SAMLAuthnContext((ProfileAction)new MockProfileAction(), (Function)new MockMessageDecoderFunction());
        authnContext.addSubcontext((BaseContext)this.samlAuthnContext);
        authnContext.addSubcontext((BaseContext)this.prcInner);
    }

    @Test
    public void testValid() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testInvalid() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.INVALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.emptyList());
    }

    @Test
    public void testIndeterminate() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.INDETERMINATE);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.emptyList());
    }

    @Test
    public void testMultipleValidNoSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        Assertion assertion2 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion2);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), List.of(assertion1, assertion2));
    }

    @Test
    public void testMultipleValidMixedSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        Assertion assertion2 = this.buildAssertion(ValidationResult.VALID);
        ((AuthnStatement)assertion2.getAuthnStatements().get(0)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(2L)));
        this.samlResponse.getAssertions().add(assertion2);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion2.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion2.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), List.of(assertion1, assertion2));
    }

    @Test
    public void testMixedValidity() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.INVALID);
        this.samlResponse.getAssertions().add(assertion1);
        Assertion assertion2 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion2);
        Assertion assertion3 = this.buildAssertion(ValidationResult.INDETERMINATE);
        this.samlResponse.getAssertions().add(assertion3);
        Assertion assertion4 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion4);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion2.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion2.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), List.of(assertion2, assertion4));
    }

    @Test
    public void testMultipleValidBothSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        ((AuthnStatement)assertion1.getAuthnStatements().get(0)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(1L)));
        this.samlResponse.getAssertions().add(assertion1);
        Assertion assertion2 = this.buildAssertion(ValidationResult.VALID);
        ((AuthnStatement)assertion2.getAuthnStatements().get(0)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(2L)));
        this.samlResponse.getAssertions().add(assertion2);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), List.of(assertion1, assertion2));
    }

    @Test
    public void testMultipleAuthnStatementsNoSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        assertion1.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testMultipleAuthnStatementsMixedSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        assertion1.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        ((AuthnStatement)assertion1.getAuthnStatements().get(1)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(2L)));
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(1));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testMultipleAuthnStatementsBothSessionInstant() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        ((AuthnStatement)assertion1.getAuthnStatements().get(0)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(1L)));
        assertion1.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        ((AuthnStatement)assertion1.getAuthnStatements().get(1)).setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(2L)));
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)this.samlAuthnContext.getSubject(), (Object)assertion1.getSubject());
        Assert.assertSame((Object)this.samlAuthnContext.getAuthnStatement(), assertion1.getAuthnStatements().get(0));
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testNoResponse() throws ComponentInitializationException {
        this.prcInner.getInboundMessageContext().setMessage(null);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.emptyList());
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.emptyList());
    }

    @Test
    public void testNoSAMLAuthnContext() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).removeSubcontext(SAMLAuthnContext.class);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testAssertionNotValidated() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(null);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.emptyList());
    }

    @Test
    public void testNoAuthnStatement() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        assertion1.getAuthnStatements().clear();
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testNoConfirmedSubject() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        ((ValidationProcessingData)assertion1.getObjectMetadata().get(ValidationProcessingData.class).get(0)).getContext().getDynamicParameters().remove("saml2.ConfirmedSubjectConfirmation");
        this.samlResponse.getAssertions().add(assertion1);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidCredentials");
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test
    public void testActionInactive() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.samlAuthnContext.getSubject());
        Assert.assertNull((Object)this.samlAuthnContext.getAuthnStatement());
        Assert.assertEquals((Collection)this.samlResponse.getAssertions(), Collections.singletonList(assertion1));
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNullAuthnAssertionStrategy() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.setAuthnAssertionSelectionStrategy(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNullAuthnStatementStrategy() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.setAuthnStatementSelectionStrategy(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNullResponseResolver() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.setResponseResolver(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNullSAMLAuthnContextStrategy() throws ComponentInitializationException {
        Assertion assertion1 = this.buildAssertion(ValidationResult.VALID);
        this.samlResponse.getAssertions().add(assertion1);
        this.action.setSAMLAuthnContextLookupStrategy(null);
        this.action.initialize();
    }

    private Assertion buildAssertion(ValidationResult validationResult) {
        SubjectConfirmation sc = (SubjectConfirmation)XMLObjectSupport.buildXMLObject((QName)SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        Subject subject = SAML2ActionTestingSupport.buildSubject((String)"testUser");
        subject.getSubjectConfirmations().add(sc);
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        assertion.setSubject(subject);
        assertion.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        if (validationResult != null) {
            assertion.getObjectMetadata().put((Object)new ValidationProcessingData(this.buildValidationContext(sc), validationResult));
        }
        return assertion;
    }

    private ValidationContext buildValidationContext(SubjectConfirmation sc) {
        ValidationContext vc = new ValidationContext();
        vc.getDynamicParameters().put("saml2.ConfirmedSubjectConfirmation", sc);
        return vc;
    }

    private static class MockMessageDecoderFunction
    implements Function<String, MessageDecoder> {
        private MockMessageDecoderFunction() {
        }

        @Override
        public MessageDecoder apply(String t) {
            return null;
        }
    }

    private static class MockProfileAction
    implements ProfileAction {
        private MockProfileAction() {
        }

        public boolean isInitialized() {
            return true;
        }

        public void initialize() throws ComponentInitializationException {
        }

        public void execute(ProfileRequestContext profileRequestContext) {
        }
    }
}

