/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ByteAttributeTranscoder
extends AbstractSAML2AttributeTranscoder<ByteAttributeValue> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2ByteAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof ByteAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull ByteAttributeValue value) throws AttributeEncodingException {
        Boolean encodeType = (Boolean)rule.getOrDefault("saml2.encodeType", Boolean.class, (Object)Boolean.TRUE);
        try {
            return SAMLEncoderSupport.encodeByteArrayValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (byte[])value.getValue(), (boolean)encodeType);
        }
        catch (EncodingException e) {
            throw new AttributeEncodingException("Attribtue value could not be encoded", (Exception)((Object)e));
        }
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        String s = this.getStringValue(value);
        if (null == s) {
            return null;
        }
        try {
            byte[] decoded = Base64Support.decode((String)s);
            if (decoded.length == 0) {
                this.log.warn("Ignoring non-base64-encoded value");
                return null;
            }
            return ByteAttributeValue.valueOf((byte[])decoded);
        }
        catch (DecodingException e) {
            this.log.warn("Ignoring non-base64-encoded value: {}", (Object)e.getMessage());
            return null;
        }
    }
}

