/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class StatusCodeAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public StatusCodeAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof Response) {
                org.opensaml.saml.saml1.core.StatusCode sc;
                org.opensaml.saml.saml1.core.StatusCode statusCode = sc = ((Response)response).getStatus() != null ? ((Response)response).getStatus().getStatusCode() : null;
                if (sc != null && sc.getValue() != null) {
                    return sc.getValue().getLocalPart();
                }
            } else if (response instanceof StatusResponseType) {
                StatusCode sc;
                StatusCode statusCode = sc = ((StatusResponseType)response).getStatus() != null ? ((StatusResponseType)response).getStatus().getStatusCode() : null;
                if (sc != null) {
                    return sc.getValue();
                }
            }
        }
        return null;
    }
}

