/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSAMLSelfEntityContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateSAMLSelfEntityContext.class);
    @Nullable
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new ResponderIdLookupFunction();
    @Nullable
    private String selfIdentity;

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.selfIdentity = this.selfIdentityLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLSelfEntityContext context;
        if (profileRequestContext.getInboundMessageContext() != null && (context = (SAMLSelfEntityContext)profileRequestContext.getInboundMessageContext().getSubcontext(SAMLSelfEntityContext.class)) != null && !Objects.equals(context.getEntityId(), this.selfIdentity)) {
            this.log.debug("{} Updating inbound SAMLSelfEntityContext, '{}' to '{}'", new Object[]{this.getLogPrefix(), context.getEntityId(), this.selfIdentity});
            context.setEntityId(this.selfIdentity);
        }
        if (profileRequestContext.getOutboundMessageContext() != null && (context = (SAMLSelfEntityContext)profileRequestContext.getOutboundMessageContext().getSubcontext(SAMLSelfEntityContext.class)) != null && !Objects.equals(context.getEntityId(), this.selfIdentity)) {
            this.log.debug("{} Updating outbound SAMLSelfEntityContext, '{}' to '{}'", new Object[]{this.getLogPrefix(), context.getEntityId(), this.selfIdentity});
            context.setEntityId(this.selfIdentity);
        }
    }
}

