/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.soap.messaging.AbstractHeaderGeneratingMessageHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSenderHandler
extends AbstractHeaderGeneratingMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddSenderHandler.class);
    @Nonnull
    private Function<MessageContext, String> providerIdLookupFunction = new SAMLSelfEntityIDLookupFunction();
    private String providerId;

    public void setProviderIdLookupFunction(Function<MessageContext, String> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.providerIdLookupFunction = (Function)Constraint.isNotNull(function, (String)"ProviderId lookup function may not be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.providerId = this.providerIdLookupFunction.apply(messageContext);
        if (this.providerId != null) {
            this.log.debug("Resolved Liberty ID-WSF Sender providerId value: {}", (Object)this.providerId);
            return true;
        }
        this.log.debug("Unable to resolve Liberty ID-WSF Sender providerId value, skipping further processing");
        return false;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("Issuing Liberty ID-WSF Sender with providerId value: {}", (Object)this.providerId);
        Sender sender = (Sender)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME);
        sender.setProviderID(this.providerId);
        this.decorateGeneratedHeader(messageContext, (XMLObject)sender);
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageContext, (XMLObject)sender);
    }

    public static class SAMLSelfEntityIDLookupFunction
    implements Function<MessageContext, String> {
        @Override
        @Nullable
        public String apply(@Nullable MessageContext input) {
            SAMLSelfEntityContext selfContext;
            if (input != null && (selfContext = (SAMLSelfEntityContext)input.getSubcontext(SAMLSelfEntityContext.class)) != null) {
                return selfContext.getEntityId();
            }
            return null;
        }
    }
}

